--[[
Author: HoFFi

Version: V1.0.1.0 FS19

Changelog:
	V1.0.0.0	- initial release
	V1.0.1.0	- added sound for wipers

Mod Idee: 
	McBee: 	Wäre es per Script machbar, dass man Regentropfen(Geräusch) im Schlepper hört, wenn es regnet?
]]


InDoorRainSound = {};
local _modDirectory = g_currentModDirectory

function InDoorRainSound.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function InDoorRainSound.registerEventListeners(vehicleType)    
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", InDoorRainSound)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", InDoorRainSound)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", InDoorRainSound)
    SpecializationUtil.registerEventListener(vehicleType, "onLeaveVehicle", InDoorRainSound)
end

function InDoorRainSound:onPreLoad(savegame)
	print("InDoorRainSound: loaded")
	
	local modDescXMLFile = loadXMLFile("modDescXMLFile", _modDirectory .. "modDesc.xml")
	self.rainSoundFile = Utils.getNoNil(getXMLString(modDescXMLFile, "modDesc.InDoorRainSound#rainSoundFile"), "$data/sounds/maps/environment/shared/xml/rain_interior2.ogg")
	self.wiperSoundFile = Utils.getNoNil(getXMLString(modDescXMLFile, "modDesc.InDoorRainSound#wiperSoundFile"), "wiper_sound.ogg")
	self.wiperAnimation = getXMLString(self.xmlFile, "vehicle.wipers.wiper#animName")
	self.rainSoundVolume = 0.3
	self.wiperSoundVolume = 1.5
end;

function InDoorRainSound:onPostLoad(savegame)
    
    if self.isClient then
        local fileName = Utils.getFilename( self.rainSoundFile, self.baseDirectory )
		self.rainSample = createSample("rainSampleSound")
		loadSample(self.rainSample, fileName, false)
		
		local fileName2 = Utils.getFilename( self.wiperSoundFile, _modDirectory )
		self.wiperSample = createSample("wiperSampleSound")
		loadSample(self.wiperSample, _modDirectory..self.wiperSoundFile, false)
    end
    
end

function InDoorRainSound:onUpdate(dt)
	


	if self:getIsControlled() then
		if self:getActiveCamera() ~= nil then
			local activeCamera = self:getActiveCamera()
			if activeCamera.isInside then
				if g_currentMission.environment.weather:getIsRaining() then
					
					if not isSamplePlaying(self.rainSample) then
						playSample(self.rainSample, 0, self.rainSoundVolume, 0, 0, 0) -- playSample(sample, loop count (0=endless), volume (float))
					end
					
					if self:getIsMotorStarted() == false and self.wiperAnimation ~= nil then
						if self.wiperAnimation ~= nil then
							playSample(self.wiperSample, 0, self.wiperSoundVolume, 0, 0, 0)
						end
					end
				else
					if self.rainSample ~= nil then
						stopSample(self.rainSample, 0, 400)
						stopSample(self.wiperSample, 0, 400)
					end
				end
			else
				if self.rainSample ~= nil then
					stopSample(self.rainSample, 0, 400)
					stopSample(self.wiperSample, 0, 400)
				end
			end
		end
	else
		if self.rainSample ~= nil then
			stopSample(self.rainSample, 0, 400)
			stopSample(self.wiperSample, 0, 400)
		end
	end
end;

function InDoorRainSound:onLeaveVehicle(dt)
	if self.rainSample ~= nil then
		stopSample(self.rainSample, 0, 400)
		stopSample(self.wiperSample, 0, 400)
	end
end

addModEventListener(InDoorRainSound);