----------------------------------------------------------------------------------------------------
-- SectionLiftSectionEvent
----------------------------------------------------------------------------------------------------
-- Purpose: Event toggling section lift.
--
-- Copyright (c) Wopster, 2020
----------------------------------------------------------------------------------------------------

---@class SectionLiftEvent
SectionLiftEvent = {}
local SectionLiftEvent_mt = Class(SectionLiftEvent, Event)

InitEventClass(SectionLiftEvent, "SectionLiftEvent")

function SectionLiftEvent:emptyNew()
    local self = Event:new(SectionLiftEvent_mt)

    return self
end

function SectionLiftEvent:new(vehicle, state)
    local self = SectionLiftEvent:emptyNew()
    self.vehicle = vehicle
    self.state = state

    return self
end

function SectionLiftEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.state = streamReadBool(streamId)

    self:run(connection)
end

function SectionLiftEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteBool(streamId, self.state)
end

function SectionLiftEvent:run(connection)
    self.vehicle:setSectionLiftActive(self.state, true)

    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end
end

function SectionLiftEvent.sendEvent(vehicle, state, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(SectionLiftEvent:new(vehicle, state), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(SectionLiftEvent:new(vehicle, state))
        end
    end
end
