----------------------------------------------------------------------------------------------------
-- SectionLiftSectionEvent
----------------------------------------------------------------------------------------------------
-- Purpose: Event for lifting sections.
--
-- Copyright (c) Wopster, 2020
----------------------------------------------------------------------------------------------------

---@class SectionLiftSectionEvent
SectionLiftSectionEvent = {}
local SectionLiftSectionEvent_mt = Class(SectionLiftSectionEvent, Event)

InitEventClass(SectionLiftSectionEvent, "SectionLiftSectionEvent")

function SectionLiftSectionEvent:emptyNew()
    local self = Event:new(SectionLiftSectionEvent_mt)

    return self
end

function SectionLiftSectionEvent:new(vehicle, sectionId, direction, moveToMiddle, force)
    local self = SectionLiftSectionEvent:emptyNew()
    self.vehicle = vehicle
    self.sectionId = sectionId
    self.direction = MathUtil.sign(direction)
    self.moveToMiddle = moveToMiddle
    self.force = force

    return self
end

function SectionLiftSectionEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.sectionId = streamReadUIntN(streamId, 2)
    self.direction = streamReadUIntN(streamId, 2) - 1
    self.moveToMiddle = streamReadBool(streamId)
    self.force = streamReadBool(streamId)

    self:run(connection)
end

function SectionLiftSectionEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteUIntN(streamId, self.sectionId, 2)
    streamWriteUIntN(streamId, self.direction + 1, 2)
    streamWriteBool(streamId, self.moveToMiddle)
    streamWriteBool(streamId, self.force)
end

function SectionLiftSectionEvent:run(connection)
    if self.vehicle ~= nil then
        self.vehicle:setSectionDirection(self.sectionId, self.direction, self.moveToMiddle, self.force, true)
    end

    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end
end

function SectionLiftSectionEvent.sendEvent(vehicle, sectionId, direction, moveToMiddle, force, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(SectionLiftSectionEvent:new(vehicle, sectionId, direction, moveToMiddle, force), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(SectionLiftSectionEvent:new(vehicle, sectionId, direction, moveToMiddle, force))
        end
    end
end
