--
-- DoorOpener
--
-- written by fruktor, visit: www.eifok-team.de
-- Edit by CatFan18 Mods

DoorOpener = {};

DoorOpener.modDir = g_currentModDirectory;

function DoorOpener.prerequisitesPresent(specializations)
    return true; 
end;

function DoorOpener:load(savegame)
--  Lewe drzwi
	self.playerCallbackLewe_Drzwi = SpecializationUtil.callSpecializationsFunction("playerCallbackLewe_Drzwi"); 
	
	self.doorO = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.Lewe_Drzwi#trigger")) );
	if trigger == nil then
		print("[Error::Lewe_Drzwi] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.Lewe_Drzwi#icIndex", i));
	
	self.doorO.icIndex = icIndex;
	self.doorO.trigger = trigger;
	self.doorO.plIR = false;
	
	addTrigger( trigger, "playerCallbackLewe_Drzwi", self );
	
--  Prawe drzwi
	self.playerCallbackPrawe_Drzwi = SpecializationUtil.callSpecializationsFunction("playerCallbackPrawe_Drzwi"); 
	
	self.door1 = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.Prawe_Drzwi#trigger")) );
	if trigger == nil then
		print("[Error::Prawe_Drzwi] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.Prawe_Drzwi#icIndex", i));
	
	self.door1.icIndex = icIndex;
	self.door1.trigger = trigger;
	self.door1.plIR = false;
	
	addTrigger( trigger, "playerCallbackPrawe_Drzwi", self );
	
--	Szyba
	self.playerCallbackTylna_Szyba = SpecializationUtil.callSpecializationsFunction("playerCallbackTylna_Szyba"); 
	
	self.door2 = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.Tylna_Szyba#trigger")) );
	if trigger == nil then
		print("[Error::Tylna_Szyba] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.Tylna_Szyba#icIndex", i));
	
	self.door2.icIndex = icIndex;
	self.door2.trigger = trigger;
	self.door2.plIR = false;
	
	addTrigger( trigger, "playerCallbackTylna_Szyba", self );		
end;

function DoorOpener:delete()
--  Lewe drzwi
	if self.doorO.trigger ~= nil then
		removeTrigger(self.doorO.trigger);
	end;
--  Prawe drzwi
	if self.door1.trigger ~= nil then
		removeTrigger(self.door1.trigger);
	end;
--  Szyba
	if self.door2.trigger ~= nil then
		removeTrigger(self.door2.trigger);
	end;
end;

function DoorOpener:readStream(streamId, connection)
end;

function DoorOpener:writeStream(streamId, connection)
end;

function DoorOpener:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DoorOpener:keyEvent(unicode, sym, modifier, isDown)
end;

function DoorOpener:update(dt)
	if self.doorO.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_LEWE_DRZWI"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_LEWE_DRZWI") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.doorO.icIndex];
			if obj ~= nil then
				self:doActionOnObject(self.doorO.icIndex);
			end;
		end
	end;
	if self.door1.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_PRAWE_DRZWI"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_PRAWE_DRZWI") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.door1.icIndex];
			if obj ~= nil then
				self:doActionOnObject(self.door1.icIndex);
			end;
		end
	end;
	if self.door2.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_TYLNA_SZYBA"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_TYLNA_SZYBA") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.door2.icIndex];
			if obj ~= nil then
				self:doActionOnObject(self.door2.icIndex);
			end;
		end
	end;		
end;


function DoorOpener:onLeave()
end;

function DoorOpener:draw()
end;

function DoorOpener:playerCallbackLewe_Drzwi(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorO.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorO.plIR = false;
	end;
end;

function DoorOpener:playerCallbackPrawe_Drzwi(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door1.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door1.plIR = false;
	end;
end;

function DoorOpener:playerCallbackTylna_Szyba(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door2.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door2.plIR = false;
	end;
end;


