-- Sounds.lua
-- Script for Deutz-Fahr TTV7 Series V5.4.1.0 powered by STv-Modding
--
-- Author Rival renamed: Thomas0815
-- 05.01.2016
-- Version 1.1 @26.10.2016
	--> converted to FS17
-- Version 1.2 @05.11.2016
	--> added indoorsound change when door/windows are open
-- Version 1.3 @28.12.2016 edit DerFreddy7
	--> added Xerion Lenkrad sound
	--> added Xerion Cebis terminal Sound
-- Version 1.4 @08.01.2017 edit Thomas0815
	--> changes for Sounds
-- Verions 1.5 16.05.2017 edit by STv-Modding
    --> added new extra sounds for IC Buttons(STv-Modding)
Sounds = {};

function Sounds.prerequisitesPresent(specializations)
    return true;
end;

function Sounds:load(savegame)
	if self.isClient then
		self.sampleOpenleftDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "Sound/Drzwi.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseleftDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "Sound/Drzwi_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenrightDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "Sound/Drzwi.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloserightDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "Sound/Drzwi_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "Sound/Szyba.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "Sound/Szyba_2.wav", self.baseDirectory, self.components[1].node);
	end;
end;

--function Sounds:postLoad(savegame)
--	for k,v in pairs(self.sampleMotor) do print(k,v) end
--end;

function Sounds:delete()
	if self.sampleOpenleftDoor ~= nil then
		SoundUtil.deleteSample(self.sampleOpenleftDoor);
	end;
	if self.sampleCloseleftDoor ~= nil then
		SoundUtil.deleteSample(self.sampleCloseleftDoor);
	end;
	if self.sampleOpenrightDoor ~= nil then
		SoundUtil.deleteSample(self.sampleOpenrightDoor);
	end;
	if self.sampleCloserightDoor ~= nil then
		SoundUtil.deleteSample(self.sampleCloserightDoor);
	end;
	if self.sampleOpenWindow ~= nil then
		SoundUtil.deleteSample(self.sampleOpenWindow);
	end;
	if self.sampleCloseWindow ~= nil then
		SoundUtil.deleteSample(self.sampleCloseWindow);
	end;
	
end;

function Sounds:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Sounds:keyEvent(unicode, sym, modifier, isDown)
end;

function Sounds:update(dt)
    if self:getIsActive() and self.isClient then
		if self.isEntered then
			if self:getIsAnimationPlaying("DoorLeft") and self:getIsActiveForSound() then
				if self.animations["DoorLeft"].currentSpeed > 0 and self.animations["DoorLeft"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenleftDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenleftDoor,1,1,nil);
					end;
				elseif self.animations["DoorLeft"].currentSpeed < 0 and self.animations["DoorLeft"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseleftDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseleftDoor,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("DoorRight") and self:getIsActiveForSound() then
				if self.animations["DoorRight"].currentSpeed > 0 and self.animations["DoorRight"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenrightDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenrightDoor,1,1,nil);
					end;
				elseif self.animations["DoorRight"].currentSpeed < 0 and self.animations["DoorRight"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloserightDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloserightDoor,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("BackWindow") and self:getIsActiveForSound() then
				if self.animations["BackWindow"].currentSpeed > 0 and self.animations["BackWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenWindow, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenWindow,1,1,nil);
					end;
				elseif self.animations["BackWindow"].currentSpeed < 0 and self.animations["BackWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseWindow, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseWindow,1,1,nil);
					end;
				end;
			end;
		end;
    end;
end;
function Sounds:updateTick(dt)
end;
function Sounds:draw()    
end;