--
-- moveCameraIntern
-- authors of original script: Manuel Leithner, Modelleicher.
-- idee & author 2017: Der Tester, Modelleicher.
-- 
------ free for non commercial-usage -------------

moveCamIntern = {};
function moveCamIntern.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function moveCamIntern:load(savegame)

	---------------------moveCameraIntern---------------------
	self.internalCamera = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.internalCamera#index"));
	self.camPositionX = 0;
	self.camPositionZ = 0;
	self.camPositionY = 0;
end;
function moveCamIntern:delete()
end;
function moveCamIntern:readStream(streamId, connection)
end;
function moveCamIntern:writeStream(streamId, connection)
end;

function moveCamIntern:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveCamIntern:keyEvent(unicode, sym, modifier, isDown)
end;

function moveCamIntern:update(dt)
	if self:getIsActive() then
	---------------------moveCameraIntern---------------------
		 if self.activeCamera.isInside then
			if InputBinding.isPressed(InputBinding.MOVECAMLEFT2) then
				self.camPositionX = self.camPositionX + 0.001875*dt;
				if self.camPositionX >= 0.3 then
					self.camPositionX = 0.3;
				end;
			end;
			if InputBinding.isPressed(InputBinding.MOVECAMRIGHT2) then
				self.camPositionX = self.camPositionX - 0.001875*dt;
				if self.camPositionX <= -0.3 then
					self.camPositionX = -0.3;
				end;
			end;
			if InputBinding.isPressed(InputBinding.MOVECAMFORWARD2) then
				self.camPositionZ = self.camPositionZ + 0.001875*dt;
				if self.camPositionZ >= 0.22 then
					self.camPositionZ = 0.22;
				end;
			end;
					if InputBinding.isPressed(InputBinding.MOVECAMBACK2) then
				self.camPositionZ = self.camPositionZ - 0.001875*dt;
				if self.camPositionZ <= -0.22 then
					self.camPositionZ = -0.22;
				end;
			end;
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
				self.camPositionY = self.camPositionY + 0.001075*dt;
				if self.camPositionY >= 0.2 then
					self.camPositionY = 0.2;
				end;
			end;
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
				self.camPositionY = self.camPositionY - 0.001075*dt;
				if self.camPositionY <= -0.2 then
					self.camPositionY = -0.2;
				end;
			end;
			if Input.isKeyPressed(Input.KEY_KP_0) then
				self.camPositionX = 0;
				self.camPositionZ = 0;
				self.camPositionY = 0;
			end;
			if self.internalCamera ~= nil then
				setTranslation(self.internalCamera, self.camPositionX, self.camPositionZ, self.camPositionY);
			end;
		end;
	end;
end;

function moveCamIntern:updateTick(dt)
end;

function moveCamIntern:draw()
end;
