                                                        -- Konwert do FS17: RomeG --
                                                              -- 26.11.2016 -- 
                                                            -- Zapraszam na: --
                            -- http://fb.com/RomeGTV http://hitbox.tv/RomeG oraz http://farming-simulator.eu --
                            
rolls = {};

function rolls.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
        
function rolls:load(selfxmlFile)
    self.rollNodes = {};

    local rollNode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
end;
function rolls:delete()
end;
function rolls:draw()
end;

function rolls:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rolls:keyEvent(unicode, sym, modifier, isDown) 
end;
 
function rolls:update(dt)  
    if self.isMotorStarted then
          for _, rollNode in pairs(self.rollNodes) do
          rotate(rollNode.node, 0, 0, -dt*rollNode.speed);
          end;
    end;
end;