---
-- CardanDirectie
-- CardanDirectie script for Steering Cardan animations.
-- Copyright (c) Sergiu, 2019 https://www.youtube.com/channel/UCiFlham5KE1HGlEhdKevnHw?view_as=subscriber
-- No permission to edit anything.
---
CardanDirectie = {};

function CardanDirectie.prerequisitesPresent(specializations)
	return true
end

function CardanDirectie.initSpecialization()
end

function CardanDirectie.registerOverwrittenFunctions(vehicleType)
	Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, CardanDirectie.registerActionEventsPlayer);
end

function CardanDirectie.registerFunctions(vehicleType)
end

function CardanDirectie.registerEvents(vehicleType)
end

function CardanDirectie:registerActionEventsPlayer()
end

function CardanDirectie:registerActionEventsMenu()
end

function CardanDirectie.registerEventListeners(vehicleType)
    EL = vehicleType.eventListeners
	table.insert(EL.onLoad, CardanDirectie)
    table.insert(EL.onUpdate, CardanDirectie)
end

function CardanDirectie:onLoad(vehicle)
	--This part only!! Is for Group 1,2,3 Animations only ("Starts here").
	VehicleTypeManager.validateVehicleTypes = Utils.prependedFunction(VehicleTypeManager.validateVehicleTypes, validateVehicleTypes)
	--This part only!! Is for Group 1,2,3 Animations only ("Ends here").
	
    -- Cardan Directie

    self.numCardanDirectie = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.CardanDirectie#count"), 0);
    self.cardanDirectie = {};
    for i=1, self.numCardanDirectie do
        local objname = string.format("vehicle.CardanDirectie.cardan" .. "%d", i);
        self.cardanDirectie[i] = {};
        self.cardanDirectie[i].index = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, objname .. "#index"));
		--print("-------------Cardan ".. self.cardanDirectie[i].index)
    end;  
  self.numCardanDirectie1 = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.CardanDirectie1#count"), 0);
     self.cardanDirectie1 = {};
    for i=1, self.numCardanDirectie1 do
        local objname = string.format("vehicle.CardanDirectie1.cardan" .. "%d", i);
        self.cardanDirectie1[i] = {};
        self.cardanDirectie1[i].index = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, objname .. "#index"));
		--print("-------------Cardan ".. self.cardanDirectie1[i].index)
    end;
	
	self.numWheelsDirectie = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.WheelsIndex#count"), 0);
    self.wheels = {};
	for i=1, self.numWheelsDirectie do
        local objname = string.format("vehicle.WheelsIndex.wheel" .. "%d", i);
        self.wheels[i] = {};
        self.wheels[i].index = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, objname .. "#index"));
		--print("-------------Wheel ".. self.wheels[i].index)
    end;  
	

end

function CardanDirectie:onUpdate(dt)
    -- Cardan Directie Toate 3 + Rotatia Rotilor din fata
    
    for i=1, self.numCardanDirectie do
        if self.wheels[i].index ~= nil then
        local x2,y2,z2 = getRotation(self.wheels[i].index);--Rotatia Rotilor din fata
        setRotation(self.cardanDirectie[1].index, x2,y2 * 17.14,z2);--Cardan 1
		setRotation(self.cardanDirectie[2].index, x2,y2 * 17.14,z2);--Cardan 2
		setRotation(self.cardanDirectie1[1].index, x2,y2 * 17.14,z2);--Cardan 3
        end;
    end;

end
    
function CardanDirectie:onDelete()
end

function CardanDirectie:mouseEvent(posX, posY, isDown, isUp, button)
end

function CardanDirectie:keyEvent(unicode, sym, modifier, isDown)
end

function CardanDirectie:onDraw()
end

