---
-- Hydraulic
-- Hydraulic script for hydraulic animations.
-- Copyright (c) Sergiu, 2019 https://www.youtube.com/channel/UCiFlham5KE1HGlEhdKevnHw?view_as=subscriber
-- No permission to edit anything.
---
Hydraulic = {};

function Hydraulic.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end

function Hydraulic.initSpecialization()
end

function Hydraulic.registerOverwrittenFunctions(vehicleType)
	Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, Hydraulic.registerActionEventsPlayer);
end

function Hydraulic.registerFunctions(vehicleType)
end

function Hydraulic.registerEvents(vehicleType)
end

function Hydraulic:registerActionEventsPlayer()
end

function Hydraulic:registerActionEventsMenu()
end

function Hydraulic.registerEventListeners(vehicleType)
    EL = vehicleType.eventListeners
	table.insert(EL.onLoad, Hydraulic)
    table.insert(EL.onUpdate, Hydraulic)
end


function Hydraulic:onLoad(vehicle)
    self.hh = {};
    self.hh.arm = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Hydraulic.backArm#index"));
    self.hh.armGetRot = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Hydraulic.backArm#getRotRef"));
    self.hh.streben = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Hydraulic.streben#index"));
    self.hh.strebenRefPoint = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Hydraulic.streben#refPoint"));
    self.hh.strebenScaleRefPoint = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Hydraulic.streben#scaleRefPoint"));
    self.hh.strebenDoScale = Utils.getNoNil(getXMLBool(self.xmlFile, "vehicle.Hydraulic.streben#doScaleBool"), false);
    
    ax, ay, az = getWorldTranslation(self.hh.streben);
    bx, by, bz = getWorldTranslation(self.hh.strebenScaleRefPoint);
    self.hh.strebenDistance = MathUtil.vector3Length(ax-bx, ay-by, az-bz);    
    
    self.hh.zylinder = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Hydraulic.zylinder#index"));
    self.hh.stempel = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.Hydraulic.zylinder#stempelIndex"));
end


function Hydraulic:onUpdate(dt)
    if self:getIsActive() then
        if self.hh ~= nil then
            -- Rotation des Hydraulikarmes --
            if self.hh.arm ~= nil then
                local rotx, roty, rotz = getRotation(self.hh.armGetRot);
                setRotation(self.hh.arm, rotx, roty, rotz);
            end
            -- Ausrichtung der Streben --
            if self.hh.streben ~= nil then
                local ax, ay, az = getWorldTranslation(self.hh.streben);
                local bx, by, bz = getWorldTranslation(self.hh.strebenRefPoint);
                x, y, z = worldDirectionToLocal(getParent(self.hh.streben), bx-ax, by-ay, bz-az);
                setDirection(self.hh.streben, x, y, z, 0, 0, 1);
                -- Skalierung der Streben fr Korrektes aussehen IG, abgeguggt bei SFM's 09er GTA, thx...  --                
                if self.hh.strebenDoScale == true then
                    local distance = MathUtil.vector3Length(ax-bx, ay-by, az-bz);
                    local scaleX, scaleY, scaleZ = getScale(self.hh.streben);
                    local setScaleWert = scaleZ * (distance / self.hh.strebenDistance);
                    setScale(self.hh.streben, 1, 1, setScaleWert);
                end
            end
            -- Ausrichtung des Zylinders und des Stempels --
            if self.hh.zylinder ~= nil and self.hh.stempel ~= nil then
                local a2x, a2y, a2z = getWorldTranslation(self.hh.zylinder);
                local b2x, b2y, b2z = getWorldTranslation(self.hh.stempel);
                x2, y2, z2 = worldDirectionToLocal(getParent(self.hh.zylinder), b2x-a2x, b2y-a2y, b2z-a2z);
                setDirection(self.hh.zylinder, x2, y2, z2, 0, 0, 1);            
                local a3x, a3y, a3z = getWorldTranslation(self.hh.stempel);
                local b3x, b3y, b3z = getWorldTranslation(self.hh.zylinder);
                x3, y3, z3 = worldDirectionToLocal(getParent(self.hh.stempel), b3x-a3x, b3y-a3y, b3z-a3z);
                setDirection(self.hh.stempel, x3, y3, z3, 0, 0, 1);
            end
        end
    end
end


function Hydraulic:onDelete()
end

function Hydraulic:mouseEvent(posX, posY, isDown, isUp, button)
end

function Hydraulic:keyEvent(unicode, sym, modifier, isDown)
end

function Hydraulic:onDraw()
end
