---
-- SchimbatorViteze
-- SchimbatorViteze script for gearshift animations.
-- Copyright (c) Sergiu, 2019 https://www.youtube.com/channel/UCiFlham5KE1HGlEhdKevnHw?view_as=subscriber
-- No permission to edit anything.
---
SchimbatorViteze = {};

function SchimbatorViteze.prerequisitesPresent(specializations)
    return true
end

function SchimbatorViteze.initSpecialization()
end

function SchimbatorViteze.registerOverwrittenFunctions(vehicleType)
	Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, SchimbatorViteze.registerActionEventsPlayer);
end

function SchimbatorViteze.registerFunctions(vehicleType)
end

function SchimbatorViteze.registerEvents(vehicleType)
end

function SchimbatorViteze:registerActionEventsPlayer()
end

function SchimbatorViteze:registerActionEventsMenu()
end

function SchimbatorViteze.registerEventListeners(vehicleType)
    EL = vehicleType.eventListeners
	table.insert(EL.onLoad, SchimbatorViteze)
    table.insert(EL.onUpdate, SchimbatorViteze)
end


function SchimbatorViteze:onLoad(vehicle)

	-- Schimbator Viteze
	self.SchimbatorViteze = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.SchimbatorViteze#index"));
end

function SchimbatorViteze:onUpdate(dt)

	-- Schimbator Viteze
	local speed = self.lastSpeed*3600;
	
		if self.SchimbatorViteze ~= nil then
			--Inapoi--
			if self.movingDirection < 0 then
               setRotation(self.SchimbatorViteze, MathUtil.degToRad(15), MathUtil.degToRad(0), MathUtil.degToRad(0));
			--Liber--
			else     
				if speed >= -0.5 and speed < 0.5 then
					setRotation(self.SchimbatorViteze, MathUtil.degToRad(0), MathUtil.degToRad(0), MathUtil.degToRad(0));
					--Inainte--
				elseif speed >= 0.5 and speed <8 then
					setRotation(self.SchimbatorViteze, MathUtil.degToRad(-11), MathUtil.degToRad(0), MathUtil.degToRad(5));

				elseif speed >= 8 and speed < 12 then
					setRotation(self.SchimbatorViteze, MathUtil.degToRad(-11), MathUtil.degToRad(0), MathUtil.degToRad(0));

				elseif speed >= 12 and speed < 24 then
					setRotation(self.SchimbatorViteze, MathUtil.degToRad(15), MathUtil.degToRad(0), MathUtil.degToRad(15));

				elseif speed >= 24 and speed < 30 then
					setRotation(self.SchimbatorViteze, MathUtil.degToRad(15), MathUtil.degToRad(0), MathUtil.degToRad(7));
               
				elseif speed >= 30 then
					setRotation(self.SchimbatorViteze, MathUtil.degToRad(-11), MathUtil.degToRad(0), MathUtil.degToRad(15));               

				end
			end
		end

end

function SchimbatorViteze:onDelete()
end

function SchimbatorViteze:mouseEvent(posX, posY, isDown, isUp, button)
end

function SchimbatorViteze:keyEvent(unicode, sym, modifier, isDown)
end

function SchimbatorViteze:onDraw()
end