-- by modelleicher
-- ls-modcompany.com
-- allows the drivers arm animation to use the steering knob to steer
-- last change: conversion to FS19 December 2019

betterSteeringAnimation = {};

function betterSteeringAnimation.prerequisitesPresent(specializations)
    return true;
end;

function betterSteeringAnimation.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", betterSteeringAnimation);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", betterSteeringAnimation);
end;


function betterSteeringAnimation:onLoad(savegame)
    self.steerKnobRot = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.drivable.betterSteeringAnimation#steerKnobRot"), self.i3dMappings);
end;

function betterSteeringAnimation:delete()
end;
function betterSteeringAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;
function betterSteeringAnimation:keyEvent(unicode, sym, modifier, isDown)
end;
function betterSteeringAnimation:onUpdate(dt)    
    if self:getIsActive() and self.spec_drivable.steeringWheel.node ~= nil then
        local rx, ry, rz = getRotation(self.spec_drivable.steeringWheel.node);
        setRotation(self.steerKnobRot, 0, ry*-1, 0);
    end; 
end;

function betterSteeringAnimation:draw()
end;
