----------------------------------------------------------------------------------------------------
-- SeasonsAvailabilityCheck
----------------------------------------------------------------------------------------------------
-- Purpose:  Removes Seasons-dependend store items from the store if Seasons is not available.
--
-- Copyright (c) Realismus Modding, 2019
----------------------------------------------------------------------------------------------------

local modDirectory = g_currentModDirectory

function isSeasonsActive()
    -- Might not be set at this point
    if g_seasons ~= nil then
        return true
    end

    if GS_IS_CONSOLE_VERSION then
        return g_modIsLoaded["FS19_RM_Seasons_console"]
    end

    return g_modIsLoaded["FS19_RM_Seasons"]
end

function ignoreSaltStoreItems(self, superFunc, xmlFilename, baseDir, ...)
    -- Do not load the salt sprayer
    if baseDir == modDirectory and xmlFilename == "hauer/TS215/TS215.xml" then
        return nil
    end

    return superFunc(self, xmlFilename, baseDir, ...)
end

function validateVehicleTypes()
    if not isSeasonsActive() then
        log("Warning: Seasons is missing. Hauer salt gritter will be removed from the store.")
        StoreManager.loadItem = Utils.overwrittenFunction(StoreManager.loadItem, ignoreSaltStoreItems)
    end
end

VehicleTypeManager.validateVehicleTypes = Utils.prependedFunction(VehicleTypeManager.validateVehicleTypes, validateVehicleTypes)
