--
-- CobreSujidadeEsquerda
--
-- @TMP
-- @31/05/2017

CobreSujidadeEsquerda = {};

CobreSujidadeEsquerda.modDir = g_currentModDirectory;

function CobreSujidadeEsquerda.prerequisitesPresent(specializations)
    return true; 
end;

function CobreSujidadeEsquerda:load(savegame)

    self.AnimacaoCobreSujidadeEsquerda = SpecializationUtil.callSpecializationsFunction("AnimacaoCobreSujidadeEsquerda"); 
    
    self.CobreSujidadeEsquerda = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.CobreSujidadeEsquerda#trigger")) );
    if trigger == nil then
        print("[Erro: CobreSujidadeEsquerda] index ok, mas o trigger nas esta localizado. Volte a ver a linha "..tostring(i+1).." no seu xml");
    end;
    
    local TS = getXMLInt(self.xmlFile, string.format("vehicle.CobreSujidadeEsquerda#IC_Numero", i));
    
    self.CobreSujidadeEsquerda.TS = TS;
    self.CobreSujidadeEsquerda.trigger = trigger;
    self.CobreSujidadeEsquerda.TMP = false;
        
    addTrigger( trigger, "AnimacaoCobreSujidadeEsquerda", self );
    
end;

function CobreSujidadeEsquerda:delete()
    if self.CobreSujidadeEsquerda.trigger ~= nil then
        removeTrigger(self.CobreSujidadeEsquerda.trigger);
    end;
end;

function CobreSujidadeEsquerda:readStream(streamId, connection)
end;

function CobreSujidadeEsquerda:writeStream(streamId, connection)
end;

function CobreSujidadeEsquerda:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CobreSujidadeEsquerda:keyEvent(unicode, sym, modifier, isDown)
end;

function CobreSujidadeEsquerda:update(dt)
    
    if self.CobreSujidadeEsquerda.TMP then
        g_currentMission:addHelpButtonText( g_i18n:getText("CobreSujidadeEsquerda"), InputBinding.Aberturas );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_CENTER);                 
        renderText( 0.53, 0.045, 0.035, g_i18n:getText("CobreSujidadeEsquerda") );
        if InputBinding.hasEvent(InputBinding.Aberturas)then
            local obj = self.interactiveObjects[self.CobreSujidadeEsquerda.TS];
            if obj ~= nil then
                self:doActionOnObject(self.CobreSujidadeEsquerda.TS);
            end;
        end
    end;
end;

function CobreSujidadeEsquerda:onLeave()
end;

function CobreSujidadeEsquerda:draw()
end;

function CobreSujidadeEsquerda:AnimacaoCobreSujidadeEsquerda(triggerId, otherId, onEnter, onLeave, onStay)
    
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.CobreSujidadeEsquerda.TMP = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.CobreSujidadeEsquerda.TMP = false;
    end;
    
end;