--
-- PortaEsquerda
--
-- @TMP
-- @31/05/2017

PortaEsquerda = {};

PortaEsquerda.modDir = g_currentModDirectory;

function PortaEsquerda.prerequisitesPresent(specializations)
    return true; 
end;

function PortaEsquerda:load(savegame)

    self.AnimacaoPortaEsquerda = SpecializationUtil.callSpecializationsFunction("AnimacaoPortaEsquerda"); 
    
    self.PortaEsquerda = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.PortaEsquerda#trigger")) );
    if trigger == nil then
        print("[Erro: PortaEsquerda] index ok, mas o trigger nas esta localizado. Volte a ver a linha "..tostring(i+1).." no seu xml");
    end;
    
    local TS = getXMLInt(self.xmlFile, string.format("vehicle.PortaEsquerda#IC_Numero", i));
    
    self.PortaEsquerda.TS = TS;
    self.PortaEsquerda.trigger = trigger;
    self.PortaEsquerda.TMP = false;
        
    addTrigger( trigger, "AnimacaoPortaEsquerda", self );
    
end;

function PortaEsquerda:delete()
    if self.PortaEsquerda.trigger ~= nil then
        removeTrigger(self.PortaEsquerda.trigger);
    end;
end;

function PortaEsquerda:readStream(streamId, connection)
end;

function PortaEsquerda:writeStream(streamId, connection)
end;

function PortaEsquerda:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PortaEsquerda:keyEvent(unicode, sym, modifier, isDown)
end;

function PortaEsquerda:update(dt)
    
    if self.PortaEsquerda.TMP then
        g_currentMission:addHelpButtonText( g_i18n:getText("PortaEsquerda"), InputBinding.Aberturas );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_CENTER);                 
        renderText( 0.53, 0.045, 0.035, g_i18n:getText("PortaEsquerda") );
        if InputBinding.hasEvent(InputBinding.Aberturas)then
            local obj = self.interactiveObjects[self.PortaEsquerda.TS];
            if obj ~= nil then
                self:doActionOnObject(self.PortaEsquerda.TS);
            end;
        end
    end;
end;

function PortaEsquerda:onLeave()
end;

function PortaEsquerda:draw()
end;

function PortaEsquerda:AnimacaoPortaEsquerda(triggerId, otherId, onEnter, onLeave, onStay)
    
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.PortaEsquerda.TMP = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.PortaEsquerda.TMP = false;
    end;
    
end;