-- author: rafftnix
-- date: 28.11.2016

-- allows us to change the actual mass via configuration 

ConfiguratableMass = {};

function ConfiguratableMass.prerequisitesPresent(specializations)
    return true;
end;

function ConfiguratableMass:load(savegame)
    self.setObjectChangeValues = Utils.overwrittenFunction(self.setObjectChangeValues, ConfiguratableMass.setObjectChangeValues);
    self.loadObjectChangeValuesFromXML = Utils.overwrittenFunction(self.loadObjectChangeValuesFromXML, ConfiguratableMass.loadObjectChangeValuesFromXML);
end;

function ConfiguratableMass:delete()
  
end;

function ConfiguratableMass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ConfiguratableMass:keyEvent(unicode, sym, modifier, isDown)
end;

function ConfiguratableMass:update(dt)
end;

function ConfiguratableMass:updateTick(dt)
end;

function ConfiguratableMass:draw()
end;

function ConfiguratableMass:loadObjectChangeValuesFromXML(oldFunc, xmlFile, key, node, object)
    -- if there is no attribute, massActive is simply nil
    object.massActive = getXMLFloat(xmlFile, key.."#massActive");
    
    if oldFunc ~= nil then
        oldFunc(self, xmlFile, key, node, object);
    end;
end;

function ConfiguratableMass:setObjectChangeValues(oldFunc, object, isActive)
    if isActive and self.isServer then
        if object.massActive ~= nil then
            setMass(object.node, object.massActive);
        end;    
    end;
    
    if oldFunc ~= nil then
        oldFunc(self, object, isActive);
    end;
end;