--
-- DoorOpener
--
-- written by fruktor, visit: www.eifok-team.de
-- Edit by }I{EKA special for MTZ-1025

DoorOpener = {};

DoorOpener.modDir = g_currentModDirectory;

function DoorOpener.prerequisitesPresent(specializations)
    return true; 
end;

function DoorOpener:load(savegame)
--  left door
    self.playerCallbackLeftDoor = SpecializationUtil.callSpecializationsFunction("playerCallbackLeftDoor"); 
    
    self.doorO = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.leftDoorOpener#trigger")) );
    if trigger == nil then
        print("[Error::LeftDoorOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
    end;
    
    local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.leftDoorOpener#icIndex", i));
    
    self.doorO.icIndex = icIndex;
    self.doorO.trigger = trigger;
    self.doorO.plIR = false;
    
    addTrigger( trigger, "playerCallbackLeftDoor", self );
    
--    kapot
    self.playerCallbackKapot = SpecializationUtil.callSpecializationsFunction("playerCallbackKapot"); 
    
    self.door2 = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.kapotOpener#trigger")) );
    if trigger == nil then
        print("[Error::KapotOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
    end;
    
    local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.kapotOpener#icIndex", i));
    
    self.door2.icIndex = icIndex;
    self.door2.trigger = trigger;
    self.door2.plIR = false;
    
    addTrigger( trigger, "playerCallbackKapot", self );    
end;

function DoorOpener:delete()
-- left door
    if self.doorO.trigger ~= nil then
        removeTrigger(self.doorO.trigger);
    end;
--  kapot
    if self.door2.trigger ~= nil then
        removeTrigger(self.door2.trigger);
    end;    
end;

function DoorOpener:readStream(streamId, connection)
end;

function DoorOpener:writeStream(streamId, connection)
end;

function DoorOpener:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DoorOpener:keyEvent(unicode, sym, modifier, isDown)
end;

function DoorOpener:update(dt)
    if self.doorO.plIR then
        g_currentMission:addHelpButtonText( g_i18n:getText("SET_LEFTDOOROPENER"), InputBinding.SET_DOOROPENER );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_LEFT);                 
        renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_LEFTDOOROPENER") );
        if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
            local obj = self.interactiveObjects[self.doorO.icIndex];
            if obj ~= nil then
                self:doActionOnObject(self.doorO.icIndex);
            end;
        end
    end;
    if self.door2.plIR then
        g_currentMission:addHelpButtonText( g_i18n:getText("SET_KAPOTOPENER"), InputBinding.SET_DOOROPENER );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_LEFT);                 
        renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_KAPOTOPENER") );
        if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
            local obj = self.interactiveObjects[self.door2.icIndex];
            if obj ~= nil then
                self:doActionOnObject(self.door2.icIndex);
            end;
        end
    end;        
end;

function DoorOpener:onLeave()
end;

function DoorOpener:draw()
end;

function DoorOpener:playerCallbackLeftDoor(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.doorO.plIR = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.doorO.plIR = false;
    end;
end;


function DoorOpener:playerCallbackKapot(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.door2.plIR = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.door2.plIR = false;
    end;
end;



