-- Series.lua
-- Script for Fendt 1000 Vario
--
-- Author Steph33
-- 23.11.2016
-- Version 1.0 @23.11.2016
    --> indoorsound change when door/Krisha/backWindow/leftWindow/RightWindow are open

Series = {};

function Series.prerequisitesPresent(specializations)
    return true;
end;

function Series:load(savegame)
    self.soundAdj = {};
    local i=0;
    while true do
        local key = string.format("vehicle.indoorsoundAdjustment.animation(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local animName = getXMLString(self.xmlFile, key.."#name");
        local lowpassGain = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#lowpassGain"), 0.5);
        local volumeFactor = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#volumeFactor"), 0.5);
        self.soundAdj[i] = {};
        self.soundAdj[i].animName = animName;
        self.soundAdj[i].volumeFactor = volumeFactor;
        self.soundAdj[i].lowpassGain = lowpassGain;
        i = i +1;
    end;
    
    if self.isClient then
        --leftDoor--
        self.sampleOpenDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "Sound/door_open.wav", self.baseDirectory, self.components[1].node);
        self.sampleCloseDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "Sound/door_close.wav", self.baseDirectory, self.components[1].node);
        --rightDoor--
        self.sampleOpenDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "Sound/door_open.wav", self.baseDirectory, self.components[1].node);
        self.sampleCloseDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "Sound/door_close.wav", self.baseDirectory, self.components[1].node);
        --Hatch--
        self.sampleOpenHatch = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openHatchSound", "Sound/side_open.wav", self.baseDirectory, self.components[1].node);
        self.sampleCloseHatch = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeHatchSound", "Sound/side_close.wav", self.baseDirectory, self.components[1].node);
        --backWindow--
        self.sampleOpenbackWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openbackWindowSound", "Sound/window_open.wav", self.baseDirectory, self.components[1].node);
        self.sampleClosebackWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closebackWindowSound", "Sound/window_close.wav", self.baseDirectory, self.components[1].node);
        --leftWindow--
        self.sampleOpenLeftWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openLeftWindowSound", "Sound/window_open.wav", self.baseDirectory, self.components[1].node);
        self.sampleCloseLeftWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeLeftWindowSound", "Sound/window_close.wav", self.baseDirectory, self.components[1].node);
        --RightWindow--
        self.sampleOpenRightWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openRightWindowSound", "Sound/window_open.wav", self.baseDirectory, self.components[1].node);
        self.sampleCloseRightWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeRightWindowSound", "Sound/window_close.wav", self.baseDirectory, self.components[1].node);
    end;
end;
--function Series:postLoad(savegame)
--    for k,v in pairs(self.sampleMotor) do print(k,v) end
--end;
function Series:delete()
    if self.sampleOpenDoorL ~= nil then
        SoundUtil.deleteSample(self.sampleOpenDoorL);
    end;
    if self.sampleOpenDoorR ~= nil then
        SoundUtil.deleteSample(self.sampleOpenDoorR);
    end;
    if self.sampleOpenHatch ~= nil then
        SoundUtil.deleteSample(self.sampleOpenHatch);
    end;
    if self.sampleOpenbackWindow ~= nil then
        SoundUtil.deleteSample(self.sampleOpenbackWindow);
    end;
    if self.sampleOpenLeftWindow ~= nil then
        SoundUtil.deleteSample(self.sampleOpenLeftWindow);
    end;
    if self.sampleOpenRightWindow ~= nil then
        SoundUtil.deleteSample(self.sampleOpenRightWindow);
    end;
    if self.sampleCloseDoorL ~= nil then
        SoundUtil.deleteSample(self.sampleCloseDoorL);
    end;
    if self.sampleCloseDoorR ~= nil then
        SoundUtil.deleteSample(self.sampleCloseDoorR);
    end;
    if self.sampleCloseHatch ~= nil then
        SoundUtil.deleteSample(self.sampleCloseHatch);
    end;
    if self.sampleClosebackWindow ~= nil then
        SoundUtil.deleteSample(self.sampleClosebackWindow);
    end;
    if self.sampleCloseLeftWindow ~= nil then
        SoundUtil.deleteSample(self.sampleCloseLeftWindow);
    end;
    if self.sampleCloseRightWindow ~= nil then
        SoundUtil.deleteSample(self.sampleCloseRightWindow);
    end;
end;
function Series:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Series:keyEvent(unicode, sym, modifier, isDown)
end;
function Series:update(dt)
    if self:getIsActive() and self.isClient then
        if self.isEntered then
            if self:getIsAnimationPlaying("leftDoor") and self:getIsActiveForSound() then
                if self.animations["leftDoor"].currentSpeed > 0 and self.animations["leftDoor"].currentTime < 50 then
                    if not SoundUtil.isSamplePlaying(self.sampleOpenDoorL, 1.5*dt) then
                        SoundUtil.playSample(self.sampleOpenDoorL,1,1,nil);
                    end;
                elseif self.animations["leftDoor"].currentSpeed < 0 and self.animations["leftDoor"].currentTime < 100 then
                    if not SoundUtil.isSamplePlaying(self.sampleCloseDoorL, 1.5*dt) then
                        SoundUtil.playSample(self.sampleCloseDoorL,1,1,nil);
                    end;
                end;
            end;
            if self:getIsAnimationPlaying("rightDoor") and self:getIsActiveForSound() then
                if self.animations["rightDoor"].currentSpeed > 0 and self.animations["rightDoor"].currentTime < 50 then
                    if not SoundUtil.isSamplePlaying(self.sampleOpenDoorR, 1.5*dt) then
                        SoundUtil.playSample(self.sampleOpenDoorR,1,1,nil);
                    end;
                elseif self.animations["rightDoor"].currentSpeed < 0 and self.animations["rightDoor"].currentTime < 100 then
                    if not SoundUtil.isSamplePlaying(self.sampleCloseDoorR, 1.5*dt) then
                        SoundUtil.playSample(self.sampleCloseDoorR,1,1,nil);
                    end;
                end;
            end;
            if self:getIsAnimationPlaying("Hatch") and self:getIsActiveForSound() then
                if self.animations["Hatch"].currentSpeed > 0 and self.animations["Hatch"].currentTime < 50 then
                    if not SoundUtil.isSamplePlaying(self.sampleOpenHatch, 1.5*dt) then
                        SoundUtil.playSample(self.sampleOpenHatch,1,1,nil);
                    end;
                elseif self.animations["Hatch"].currentSpeed < 0 and self.animations["Hatch"].currentTime < 100 then
                    if not SoundUtil.isSamplePlaying(self.sampleCloseHatch, 1.5*dt) then
                        SoundUtil.playSample(self.sampleCloseHatch,1,1,nil);
                    end;
                end;
            end;
            if self:getIsAnimationPlaying("backWindow") and self:getIsActiveForSound() then
                if self.animations["backWindow"].currentSpeed > 0 and self.animations["backWindow"].currentTime < 50 then
                    if not SoundUtil.isSamplePlaying(self.sampleOpenbackWindow, 1.5*dt) then
                        SoundUtil.playSample(self.sampleOpenbackWindow,1,1,nil);
                    end;
                elseif self.animations["backWindow"].currentSpeed < 0 and self.animations["backWindow"].currentTime < 100 then
                    if not SoundUtil.isSamplePlaying(self.sampleClosebackWindow, 1.5*dt) then
                        SoundUtil.playSample(self.sampleClosebackWindow,1,1,nil);
                    end;
                end;
            end;
            if self:getIsAnimationPlaying("LeftWindow") and self:getIsActiveForSound() then
                if self.animations["LeftWindow"].currentSpeed > 0 and self.animations["LeftWindow"].currentTime < 50 then
                    if not SoundUtil.isSamplePlaying(self.sampleOpenLeftWindow, 1.5*dt) then
                        SoundUtil.playSample(self.sampleOpenLeftWindow,1,1,nil);
                    end;
                elseif self.animations["LeftWindow"].currentSpeed < 0 and self.animations["LeftWindow"].currentTime > 50 then
                    if not SoundUtil.isSamplePlaying(self.sampleCloseLeftWindow, 1.5*dt) then
                        SoundUtil.playSample(self.sampleCloseLeftWindow,1,1,nil);
                    end;
                end;
            end;
            if self:getIsAnimationPlaying("RightWindow") and self:getIsActiveForSound() then
                if self.animations["RightWindow"].currentSpeed > 0 and self.animations["RightWindow"].currentTime < 50 then
                    if not SoundUtil.isSamplePlaying(self.sampleOpenRightWindow, 1.5*dt) then
                        SoundUtil.playSample(self.sampleOpenRightWindow,1,1,nil);
                    end;
                elseif self.animations["RightWindow"].currentSpeed < 0 and self.animations["RightWindow"].currentTime < 100 then
                    if not SoundUtil.isSamplePlaying(self.sampleCloseRightWindow, 1.5*dt) then
                        SoundUtil.playSample(self.sampleCloseRightWindow,1,1,nil);
                    end;
                end;
            end;
            local sound=false;
            for i=0, #self.soundAdj do
                if self.animations[self.soundAdj[i].animName] ~= nil and self.animations[self.soundAdj[i].animName].currentTime > 500 then
                    self.sampleMotor.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotor.indoorVolumeFactor);
                    self.sampleMotor.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotor.indoorLowpassGain);
                    self.sampleMotorStart.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStart.indoorVolumeFactor);
                    self.sampleMotorStart.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStart.indoorLowpassGain);
                    self.sampleMotorStop.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStop.indoorVolumeFactor);
                    self.sampleMotorStop.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStop.indoorLowpassGain);
                    
                    self.sampleMotorRun.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorRun.indoorVolumeFactor);
                    self.sampleMotorRun.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorRun.indoorLowpassGain);
                    self.sampleMotorLoad.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorLoad.indoorVolumeFactor);
                    self.sampleMotorLoad.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorLoad.indoorLowpassGain);
                    sound=true;
                else
                    if not sound then
                        self.sampleMotor.indoorVolumeFactor = 0.55;
                        self.sampleMotor.indoorLowpassGain = 0.2;
                        self.sampleMotorStart.indoorVolumeFactor = 0.55;
                        self.sampleMotorStart.indoorLowpassGain = 0.2;
                        self.sampleMotorStop.indoorVolumeFactor = 0.55;
                        self.sampleMotorStop.indoorLowpassGain = 0.2;
                        
                        self.sampleMotorRun.indoorVolumeFactor = 0.6;
                        self.sampleMotorRun.indoorLowpassGain = 0.2;
                        self.sampleMotorLoad.indoorVolumeFactor = 0.6;
                        self.sampleMotorLoad.indoorLowpassGain = 0.2;
                    end;
                end;
            end;
            SoundUtil.onCameraSwitched(self.activeCamera.isInside);
        end;
    end;
end;
function Series:updateTick(dt)
end;
function Series:draw()    
end;