
-- NewConfiguration
-- Author FS19 Aluha74rus
-- 21.04.2019
--
NewConfiguration = {};


function NewConfiguration.prerequisitesPresent(specializations)
    return true;
end

function NewConfiguration.initSpecialization()
    g_configurationManager:addConfigurationType("baseMaterial", g_i18n:getText("configuration_baseColor"), nil, nil, ConfigurationUtil.getConfigColorSingleItemLoad, ConfigurationUtil.getConfigColorPostLoad, ConfigurationUtil.SELECTOR_COLOR)
    g_configurationManager:addConfigurationType("designMaterial", g_i18n:getText("configuration_designColor"), nil, nil, ConfigurationUtil.getConfigColorSingleItemLoad, ConfigurationUtil.getConfigColorPostLoad, ConfigurationUtil.SELECTOR_COLOR)
    g_configurationManager:addConfigurationType("newMaterial", g_i18n:getText("configuration_newColor"), nil, nil, ConfigurationUtil.getConfigColorSingleItemLoad, ConfigurationUtil.getConfigColorPostLoad, ConfigurationUtil.SELECTOR_COLOR)
    g_configurationManager:addConfigurationType("newReshMaterial", g_i18n:getText("configuration_newReshColor"), nil, nil, ConfigurationUtil.getConfigColorSingleItemLoad, ConfigurationUtil.getConfigColorPostLoad, ConfigurationUtil.SELECTOR_COLOR)
end
BaseMaterial.initSpecialization = Utils.overwrittenFunction(BaseMaterial.initSpecialization, NewConfiguration.initSpecialization);

function NewConfiguration:onLoad(savegame)
    local spec = self.spec_baseMaterial
    spec.baseMaterials = {}
    spec.nameToMaterial = {}
    local i = 0
    while true do
        local key = string.format("vehicle.baseMaterial.material(%d)", i)
        if not hasXMLProperty(self.xmlFile, key) then
            break
        end
        local baseMaterial = {}
        if self:loadBaseMaterialFromXML(self.xmlFile, key, baseMaterial) then
            spec.nameToMaterial[baseMaterial.name] = baseMaterial
            table.insert(spec.baseMaterials, baseMaterial)
        end
        i = i + 1
    end
    if self.configurations["baseMaterial"] ~= nil then
        self:applyBaseMaterialConfiguration(self.xmlFile, "baseMaterial", self.configurations["baseMaterial"])
    end
    if self.configurations["designMaterial"] ~= nil then
        self:applyBaseMaterialConfiguration(self.xmlFile, "designMaterial", self.configurations["designMaterial"])
    end
    if self.configurations["newMaterial"] ~= nil then
        self:applyBaseMaterialConfiguration(self.xmlFile, "newMaterial", self.configurations["newMaterial"])
    end
    if self.configurations["newReshMaterial"] ~= nil then
        self:applyBaseMaterialConfiguration(self.xmlFile, "newReshMaterial", self.configurations["newReshMaterial"])
    end
    self:applyBaseMaterial()
end
BaseMaterial.onLoad = Utils.overwrittenFunction(BaseMaterial.onLoad, NewConfiguration.onLoad);