﻿--
--
--
--Wiper
--
--

Wiper = {};

function Wiper.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Wiper:load(savegame)

    self.statesWiper = SpecializationUtil.callSpecializationsFunction("statesWiper");

    self.loweringAll = false;
    -- Front wiper animation
    local wiperFrontAnimRootNode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wiperFront#rootNode"));
    self.wiperFrontAnimCharSet = 0;
    if wiperFrontAnimRootNode ~= nil and wiperFrontAnimRootNode ~= 0 then
        self.wiperFrontAnimCharSet = getAnimCharacterSet(wiperFrontAnimRootNode);
        if self.wiperFrontAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperFrontAnimCharSet, getXMLString(self.xmlFile, "vehicle.wiperFront#clip"));
            assignAnimTrackClip(self.wiperFrontAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperFrontAnimCharSet, 0, true);
            local wiperFrontAnimSpeedScale = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.wiperFront#speedScale"), 1);
            setAnimTrackSpeedScale(self.wiperFrontAnimCharSet, 0, wiperFrontAnimSpeedScale);
            self.wiperFrontAnimDuration = getAnimClipDuration(self.wiperFrontAnimCharSet, clip);
       end;
    end;
            self.wiperFrontCorona = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wiperFront#corona"));
            if self.wiperFrontCorona ~= nil then
                setVisibility(self.wiperFrontCorona, false);
            end;

    self.isWiperFrontActive = false;
    self.finishWiperFront = true;

    -- Rear wiper animation
    local wiperBackAnimRootNode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wiperBack#rootNode"));
    self.wiperBackAnimCharSet = 0;
    if wiperBackAnimRootNode ~= nil and wiperBackAnimRootNode ~= 0 then
        self.wiperBackAnimCharSet = getAnimCharacterSet(wiperBackAnimRootNode);
        if self.wiperBackAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperBackAnimCharSet, getXMLString(self.xmlFile, "vehicle.wiperBack#clip"));
            assignAnimTrackClip(self.wiperBackAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperBackAnimCharSet, 0, true);
            local wiperBackAnimSpeedScale = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.wiperBack#speedScale"), 1);
            setAnimTrackSpeedScale(self.wiperBackAnimCharSet, 0, wiperBackAnimSpeedScale);
            self.wiperBackAnimDuration = getAnimClipDuration(self.wiperBackAnimCharSet, clip);
        end;
    end;
    self.isWiperBackActive = false;
    self.finishWiperBack = true;
    self.wiperFrontOn = false;
    self.wiperBackOn = false;
    
    self.wiperBackCorona = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wiperBack#corona"));
    if self.wiperBackCorona ~= nil then
        setVisibility(self.wiperBackCorona, false);
    end;

end;

function Wiper:delete()
end;

function Wiper:readStream(streamId, connection)  
    self.wiperFrontOn = streamReadBool(streamId);
    self.wiperBackOn = streamReadBool(streamId);
end;

function Wiper:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.wiperFrontOn);
    streamWriteBool(streamId, self.wiperBackOn);
end;

function Wiper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Wiper:keyEvent(unicode, sym, modifier, isDown)
end;

function Wiper:update(dt)
    if self:getIsActive() then    
        if InputBinding.hasEvent(InputBinding.WischerVo) then
            self:statesWiper(true, false);
        end;
        if InputBinding.hasEvent(InputBinding.WischerHi) then
            self:statesWiper(false, true);
        end;
    end;
end;

function Wiper:updateTick(dt)

    if self:getIsActive() then

        -- Stop wipers in correct position
        if not self.finishWiperFront then
            if getAnimTrackTime(self.wiperFrontAnimCharSet, 0) % self.wiperFrontAnimDuration <= 100 then
                setAnimTrackTime(self.wiperFrontAnimCharSet, 0, 0.0);
                disableAnimTrack(self.wiperFrontAnimCharSet, 0);
                self.finishWiperFront = true;
            end;
        end;

        if not self.finishWiperBack then
            if getAnimTrackTime(self.wiperBackAnimCharSet, 0) % self.wiperBackAnimDuration <= 100 then
                setAnimTrackTime(self.wiperBackAnimCharSet, 0, 0.0);
                disableAnimTrack(self.wiperBackAnimCharSet, 0);
                self.finishWiperBack = true;
            end;
        end;

        -- Start front wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
        if self.wiperFrontOn then
            if not self.isWiperFrontActive then
                enableAnimTrack(self.wiperFrontAnimCharSet, 0);
                self.isWiperFrontActive = true;
            end;
            if self.wiperFrontCorona ~= nil then
                setVisibility(self.wiperFrontCorona, true);
            end;
        else
            if self.isWiperFrontActive then
                self.isWiperFrontActive = false;
                self.finishWiperFront = false;
            end;
            if self.wiperFrontCorona ~= nil then
                setVisibility(self.wiperFrontCorona, false);
            end;
        end;

        if self.wiperBackOn then
            if not self.isWiperBackActive then
                enableAnimTrack(self.wiperBackAnimCharSet, 0);
                self.isWiperBackActive = true;
            end;
            if self.wiperBackCorona ~= nil then
                setVisibility(self.wiperBackCorona, true);
            end;
        else
            if self.isWiperBackActive then
                self.isWiperBackActive = false;
                self.finishWiperBack = false;
            end;
            if self.wiperBackCorona ~= nil then
                setVisibility(self.wiperBackCorona, false);
            end;
        end;
        --if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
        --end;    
    end;
end;

function Wiper:draw()
    if self:getIsActive() then
        if self.wiperFrontOn then
            g_currentMission:addHelpButtonText(g_i18n:getText("WischerVoAus"), InputBinding.WischerVo);
        elseif not self.wiperFrontOn then
            g_currentMission:addHelpButtonText(g_i18n:getText("WischerVoAn"), InputBinding.WischerVo);
        end;

        if self.wiperBackOn then
            g_currentMission:addHelpButtonText(g_i18n:getText("WischerHiAus"), InputBinding.WischerHi);
        elseif not self.wiperBackOn then
            g_currentMission:addHelpButtonText(g_i18n:getText("WischerHiAn"), InputBinding.WischerHi);
        end;

    end;

end;

function Wiper:statesWiper(front, back, noEventSend)
    if not noEventSend then
        StatesWiperEvent.sendEvent(self, front, back, noEventSend)
    end;
        if front then
            self.wiperFrontOn = (not self.wiperFrontOn)
        end;
        
        if back then
            self.wiperBackOn = (not self.wiperBackOn)
        end;

end;
function Wiper:onEnter()
         if self.isWiperFrontActive then
            enableAnimTrack(self.wiperFrontAnimCharSet, 0);
            if self.wiperFrontCorona ~= nil then
                setVisibility(self.wiperFrontCorona, false);
            end;
        end;
        if self.isWiperBackActive then
            enableAnimTrack(self.wiperBackAnimCharSet, 0);
            if self.wiperBackCorona ~= nil then
                setVisibility(self.wiperBackCorona, false);
            end;
        end;
end;
function Wiper:onLeave()

        if self.isWiperFrontActive then
            disableAnimTrack(self.wiperFrontAnimCharSet, 0);
            if self.wiperFrontCorona ~= nil then
                setVisibility(self.wiperFrontCorona, false);
            end;
         end;
        if self.isWiperBackActive then
            disableAnimTrack(self.wiperBackAnimCharSet, 0);
            if self.wiperBackCorona ~= nil then
                setVisibility(self.wiperBackCorona, false);
            end;
        end;
        
end;

StatesWiperEvent = {};
StatesWiperEvent_mt = Class(StatesWiperEvent, Event);

InitEventClass(StatesWiperEvent, "StatesWiperEvent");

function StatesWiperEvent:emptyNew()
    local self = Event:new(StatesWiperEvent_mt);
    self.className = "StatesWiperEvent";
    return self;
end;

function StatesWiperEvent:new(object, front, back)
    local self = StatesWiperEvent:emptyNew()
    self.object = object;
    self.wiperFrontOn = front;
    self.wiperBackOn = back;
    return self;
end;

function StatesWiperEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.wiperFrontOn  = streamReadBool(streamId);
    self.wiperBackOn  = streamReadBool(streamId);
    self:run(connection);
end;

function StatesWiperEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.wiperFrontOn);
    streamWriteBool(streamId, self.wiperBackOn);
end;

function StatesWiperEvent:run(connection)
  self.object:statesWiper(self.wiperFrontOn, self.wiperBackOn, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(StatesWiperEvent:new(self.object, self.wiperFrontOn, self.wiperBackOn), nil, connection, self.object);
    end;
end;

function StatesWiperEvent.sendEvent(object, front, back, noEventSend)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(StatesWiperEvent:new(object, front, back), nil, nil, object);
    else
      g_client:getServerConnection():sendEvent(StatesWiperEvent:new(object, front, back));
    end;
  end;
end;


