
easycoopclanCategory = {};

easycoopclanCategory.currentModDirectory = g_currentModDirectory;
easycoopclanCategory.debugPriority = 0;

local function printError(errorMessage, isWarning, isInfo)
	local prefix = "::ERROR:: ";
	if isWarning then
		prefix = "::WARNING:: ";
	elseif isInfo then
		prefix = "::INFO:: ";
	end;
	print(prefix .. "from designMaterialConfiguration.lua: " .. tostring(errorMessage));
end;

local function printDebug(debugMessage, priority, addString)
	if easycoopclanCategory.debugPriority >= priority then
		local prefix = "";
		if addString then
			prefix = "::DEBUG:: from designMaterialConfiguration.lua: ";
		end;
		print(prefix .. tostring(debugMessage));
	end;
end;

local function addCategory()
    printDebug("Run initSpecialization.", 1, true);
	local modDesc = loadXMLFile("modDesc", easycoopclanCategory.currentModDirectory .. "modDesc.xml");
	easycoopclanCategory.debugPriority = Utils.getNoNil(getXMLFloat(modDesc, "modDesc.storeItems.newStoreCategories#debugPriority"), easycoopclanCategory.debugPriority);
	local categoryNumber = 0;
	local supportedCategoryTypes = {
		"VEHICLE",
		"TOOL",
		"PLACEABLE",
		"OBJECT"
	};
	while true do
		local categoryKey = "modDesc.storeItems.newStoreCategories.newStoreCategory(" .. tostring(categoryNumber) .. ")";
		if not hasXMLProperty(modDesc, categoryKey) then
			break;
		end;
		local newCategoryName = getXMLString(modDesc, categoryKey .. "#name");
		if newCategoryName ~= nil  then
			newCategoryTitle = Utils.getNoNil(getXMLString(modDesc, categoryKey .. "#title"), newCategoryName);
			newCategoryType = Utils.getNoNil(string.upper(getXMLString(modDesc, categoryKey .. "#type")), "VEHICLE");
			newCategoryImage = Utils.getNoNil(getXMLString(modDesc, categoryKey .. "#image"), "imageNotDefined");
			local function getIsValidCategoryType(categoryType)
				for _, supportedCategoryType in pairs(supportedCategoryTypes) do
					if categoryType == supportedCategoryType then
						return true;
					end;
				end;
				return false;
			end;
			if getIsValidCategoryType(newCategoryType) then		
				if string.find(newCategoryImage, ".dds") then
					newCategoryImage = string.sub(newCategoryImage, 1, string.len(newCategoryImage) - 3) .. "dds";
				end;
				newCategoryImageToCheck = newCategoryImage;
				if string.sub(newCategoryTitle, 1, 6) == "$l10n_" then
					newCategoryTitle = g_i18n:getText(string.sub(newCategoryTitle, 7));
				elseif g_i18n:hasText(newCategoryTitle) then
					newCategoryTitle = g_i18n:getText(newCategoryTitle);
				end;
				if string.sub(newCategoryImage, 1, 1) == "$" then
					newCategoryImageToCheck = string.sub(newCategoryImage, 2);
				else
					newCategoryImageToCheck = Utils.getFilename(newCategoryImage, easycoopclanCategory.currentModDirectory);
				end;
				if fileExists(newCategoryImageToCheck) then
					printDebug("Added category '" .. newCategoryName .. "' successful!", 1, true);
					printDebug("Facts of category '" .. newCategoryName .. "':", 2, true);
					printDebug("    Title = '" .. newCategoryTitle .. "'.", 2, false);
					printDebug("    image filename = '" .. newCategoryImage .. "'.", 2, false);
					printDebug("    Type = '" .. newCategoryType .. "'.", 2, false);
					printDebug("", 2, false);
					g_storeManager:addCategory(newCategoryName, newCategoryTitle, newCategoryImage, newCategoryType, easycoopclanCategory.currentModDirectory);
				else
					if newCategoryImage == "imageNotDefined" then
						printError("No image for category '" .. newCategoryName .. "' defined! Category will not be added!", false, false);
					else
						printError("Failed to load '" .. newCategoryImageToCheck .. "'! Category '" .. newCategoryName .. "' will not be added!", false, false);
					end;
				end;
			else
				printError("Category type '" .. newCategoryType .. "' does not exists! Set type to 'VEHICLE', 'TOOL', 'PLACEABLE' or 'OBJECT'. The category '" .. newCategoryName .. "' will not be added!", false, false);
			end;
		else
			printError("Missing category name for category " .. categoryNumber	.. "! Category will not be added!", false, false);
		end;
		categoryNumber = categoryNumber + 1;
	end;
end;

Vehicle.init = Utils.appendedFunction(Vehicle.init, addCategory);

print("designMaterialConfiguration 29.06.19 loaded ...")