-- TMP
-- 01/06/2017
-- CanoEscape

CanoEscape = {};
CanoEscape.modDir = g_currentModDirectory;

local CanoEscape_input;

function CanoEscape.prerequisitesPresent(specializations)
    return true;
end;

function CanoEscape:load(savegame)
    self.CanoEscape_load = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.vibracao#quantidade"));
    if self.CanoEscape_load ~= nil then
        self.CanoEscape_name = {};
        self.CanoEscape_state = {};
        self.CanoEscape_help = {};
        self.CanoEscape_loop = {};
        self.CanoEscape_motor = {};
        local animacoens;
        local nome;
        local helpText;
        for a = 1, self.CanoEscape_load do
            animacoens = string.format("vehicle.vibracao.animacao%d", a);
            nome = getXMLString(self.xmlFile, animacoens .. "#name");
            helpText = getXMLBool(self.xmlFile, animacoens .. "#helpText");
            animationLoop = Utils.getNoNil(getXMLBool(self.xmlFile, animacoens .. "#animationLoop"));
            MotorOn = Utils.getNoNil(getXMLBool(self.xmlFile, animacoens .. "#MotorON"));
            table.insert(self.CanoEscape_name, nome);
            table.insert(self.CanoEscape_state, false);
            table.insert(self.CanoEscape_help, helpText);
            table.insert(self.CanoEscape_loop, animationLoop);
            table.insert(self.CanoEscape_motor, MotorOn);
            a = a + 1;
        end;
    end;
end;

function CanoEscape:delete()
end;

function CanoEscape:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CanoEscape:keyEvent(unicode, sym, modifier, isDown)
end;

function CanoEscape:update(dt)
    if self.CanoEscape_load ~= nil then
        for a = 1, self.CanoEscape_load do
            CanoEscape_input = string.format("animacao%d", a);
            if InputBinding.hasEvent(InputBinding[CanoEscape_input]) then
                if self.CanoEscape_loop[a] then
                    if self.CanoEscape_state[a] then
                        self.CanoEscape_state[a] = false;
                    else
                        self.CanoEscape_state[a] = true;
                    end;
                else
                    if self.CanoEscape_state[a] then
                        self:playAnimation(self.CanoEscape_name[a], 1, nil, true);
                        self.CanoEscape_state[a] = false;
                    else
                        self:playAnimation(self.CanoEscape_name[a], -1, nil, true);
                        self.CanoEscape_state[a] = true;
                    end;
                end;
            end;
            if self.CanoEscape_loop[a] then
                if self.CanoEscape_state[a] then
                    self:playAnimation(self.CanoEscape_name[a], 1, nil, true);
                end;
            end;
            if self.CanoEscape_loop[a] and self.CanoEscape_motor[a] then
                if self.isMotorStarted then
                    self:playAnimation(self.CanoEscape_name[a], 1, nil, true);
                end;
            end;
            a = a + 1;
        end;
    end;
end;

function CanoEscape:draw()
    if self.CanoEscape_load ~= nil then
        local help_text_button;
        for a = 1, self.CanoEscape_load do
            if self.CanoEscape_help[a] then
                help_text_button = string.format("animacao%d", a);
                g_currentMission:addHelpButtonText(g_i18n:getText(help_text_button), InputBinding[help_text_button]);
            end;
        end;
    end;
end;