--
-- CobreSujidadeDireita
--
-- @TMP
-- @31/05/2017

CobreSujidadeDireita = {};

CobreSujidadeDireita.modDir = g_currentModDirectory;

function CobreSujidadeDireita.prerequisitesPresent(specializations)
    return true; 
end;

function CobreSujidadeDireita:load(savegame)

    self.AnimacaoCobreSujidadeDireita = SpecializationUtil.callSpecializationsFunction("AnimacaoCobreSujidadeDireita"); 
    
    self.CobreSujidadeDireita = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.CobreSujidadeDireita#trigger")) );
    if trigger == nil then
        print("[Erro: CobreSujidadeDireita] index ok, mas o trigger nas esta localizado. Volte a ver a linha "..tostring(i+1).." no seu xml");
    end;
    
    local TS = getXMLInt(self.xmlFile, string.format("vehicle.CobreSujidadeDireita#IC_Numero", i));
    
    self.CobreSujidadeDireita.TS = TS;
    self.CobreSujidadeDireita.trigger = trigger;
    self.CobreSujidadeDireita.TMP = false;
        
    addTrigger( trigger, "AnimacaoCobreSujidadeDireita", self );
    
end;

function CobreSujidadeDireita:delete()
    if self.CobreSujidadeDireita.trigger ~= nil then
        removeTrigger(self.CobreSujidadeDireita.trigger);
    end;
end;

function CobreSujidadeDireita:readStream(streamId, connection)
end;

function CobreSujidadeDireita:writeStream(streamId, connection)
end;

function CobreSujidadeDireita:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CobreSujidadeDireita:keyEvent(unicode, sym, modifier, isDown)
end;

function CobreSujidadeDireita:update(dt)
    
    if self.CobreSujidadeDireita.TMP then
        g_currentMission:addHelpButtonText( g_i18n:getText("CobreSujidadeDireita"), InputBinding.Aberturas );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_CENTER);                 
        renderText( 0.5, 0.045, 0.035, g_i18n:getText("CobreSujidadeDireita") );
        if InputBinding.hasEvent(InputBinding.Aberturas)then
            local obj = self.interactiveObjects[self.CobreSujidadeDireita.TS];
            if obj ~= nil then
                self:doActionOnObject(self.CobreSujidadeDireita.TS);
            end;
        end
    end;
end;

function CobreSujidadeDireita:onLeave()
end;

function CobreSujidadeDireita:draw()
end;

function CobreSujidadeDireita:AnimacaoCobreSujidadeDireita(triggerId, otherId, onEnter, onLeave, onStay)
    
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.CobreSujidadeDireita.TMP = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.CobreSujidadeDireita.TMP = false;
    end;
    
end;