--
-- PortaDireita
--
-- @TMP
-- @31/05/2017

PortaDireita = {};

PortaDireita.modDir = g_currentModDirectory;

function PortaDireita.prerequisitesPresent(specializations)
    return true; 
end;

function PortaDireita:load(savegame)

    self.AnimacaoPortaDireita = SpecializationUtil.callSpecializationsFunction("AnimacaoPortaDireita"); 
    
    self.PortaDireita = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.PortaDireita#trigger")) );
    if trigger == nil then
        print("[Erro: PortaDireita] index ok, mas o trigger nas esta localizado. Volte a ver a linha "..tostring(i+1).." no seu xml");
    end;
    
    local TS = getXMLInt(self.xmlFile, string.format("vehicle.PortaDireita#IC_Numero", i));
    
    self.PortaDireita.TS = TS;
    self.PortaDireita.trigger = trigger;
    self.PortaDireita.TMP = false;
        
    addTrigger( trigger, "AnimacaoPortaDireita", self );
    
end;

function PortaDireita:delete()
    if self.PortaDireita.trigger ~= nil then
        removeTrigger(self.PortaDireita.trigger);
    end;
end;

function PortaDireita:readStream(streamId, connection)
end;

function PortaDireita:writeStream(streamId, connection)
end;

function PortaDireita:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PortaDireita:keyEvent(unicode, sym, modifier, isDown)
end;

function PortaDireita:update(dt)
    
    if self.PortaDireita.TMP then
        g_currentMission:addHelpButtonText( g_i18n:getText("PortaDireita"), InputBinding.Aberturas );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_CENTER);                 
        renderText( 0.53, 0.045, 0.035, g_i18n:getText("PortaDireita") );
        if InputBinding.hasEvent(InputBinding.Aberturas)then
            local obj = self.interactiveObjects[self.PortaDireita.TS];
            if obj ~= nil then
                self:doActionOnObject(self.PortaDireita.TS);
            end;
        end
    end;
end;

function PortaDireita:onLeave()
end;

function PortaDireita:draw()
end;

function PortaDireita:AnimacaoPortaDireita(triggerId, otherId, onEnter, onLeave, onStay)
    
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.PortaDireita.TMP = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.PortaDireita.TMP = false;
    end;
    
end;