-- Bale Control Unit Script (Fill Level / Bale Count Daily / Bale Count Total)
-- Created by: Farming Agency (KiBo and Bull24) - Original Authors
-- Revision:   1.0.0.0
-- Copyright:  July 2020 Farming Agency (KiBo and Bull24)
-- Created for: 4D Modding D1000 Baler (July 2020)
-- Permission is required to use / modify this script from original creators
BalerInfo = {};
BalerInfo.currentModName = g_currentModName;

function BalerInfo.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function BalerInfo.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", BalerInfo)
end;

function BalerInfo.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "baleFillLevel", BalerInfo.baleFillLevel)
	SpecializationUtil.registerFunction(vehicleType, "baleCount", BalerInfo.baleCount)
	SpecializationUtil.registerFunction(vehicleType, "allBaleCount", BalerInfo.allBaleCount)
	SpecializationUtil.registerFunction(vehicleType, "getSpeci", BalerInfo.getSpeci)
end;

function BalerInfo:onLoad(savegame)
	if self.loadDashboardsFromXML ~= nil then
		self:loadDashboardsFromXML(
			self.xmlFile, 
			"vehicle.balerInfo.dashboards", 
			
			{
				valueTypeToLoad = "fillLevel",
				valueObject = self,
				valueFunc = "baleFillLevel",
				minFunc = 0,
				maxFunc = 9999
			}
		);
		self:loadDashboardsFromXML(
			self.xmlFile, 
			"vehicle.balerInfo.dashboards",

			{
				valueTypeToLoad = "baleCount",
				valueObject = self,
				valueFunc = "baleCount",
				minFunc = 0,
				maxFunc = 9999
			}
		);
		self:loadDashboardsFromXML(
			self.xmlFile, 
			"vehicle.balerInfo.dashboards",

			{
				valueTypeToLoad = "allBaleCount",
				valueObject = self,
				valueFunc = "allBaleCount",
				minFunc = 0,
				maxFunc = 9999
			}
		);
	end;
end;


function BalerInfo:baleFillLevel()
	local balerFillLevel = 0;
	
	if self:getIsActive() then	
		for counter = 1, #g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer do
			if Utils.getNoNil(g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer[counter].fillLevel, 0) > 0  then
				balerFillLevel = balerFillLevel + Utils.getNoNil(g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer[counter].fillLevel, 0);
			end;
		end;
	end;

	return balerFillLevel;
end;

function BalerInfo:baleCount()
	local currentBaleCount = 0;

	if self:getIsActive() then
		local specAttaJs = self.spec_attacherJoints;
		
		for attachedImplement = 1, #specAttaJs.attachedImplements do
			local attached = specAttaJs.attachedImplements[attachedImplement].object;
			local specBaleCounter = self:getSpeci(attached, "baleCounter");
			local specBaleCounterSH = self:getSpeci(attached, "strawHarvestBaleCounter");

			if specBaleCounter ~= nil and specBaleCounter.countToday ~= nil then
				currentBaleCount = specBaleCounter.countToday;
			end;
			if specBaleCounterSH ~= nil and specBaleCounterSH.currentCount ~= nil then
				currentBaleCount = specBaleCounterSH.currentCount;
			end;
		end;
	end;

	return currentBaleCount;
end;

function BalerInfo:allBaleCount()
	local totalBaleCount = 0;

	if self:getIsActive() then
		local specAttaJs = self.spec_attacherJoints;
		
		for attachedImplement = 1, #specAttaJs.attachedImplements do
			local attached = specAttaJs.attachedImplements[attachedImplement].object;
			local specBaleCounter = self:getSpeci(attached, "baleCounter");
			local specBaleCounterSH = self:getSpeci(attached, "strawHarvestBaleCounter");

			if specBaleCounter ~= nil and specBaleCounter.countTotal ~= nil then
				totalBaleCount = specBaleCounter.countTotal;
			end;
			if specBaleCounterSH ~= nil and specBaleCounterSH.lifetimeCount ~= nil then
				totalBaleCount = specBaleCounterSH.lifetimeCount;
			end;
		end;
	end;

	return totalBaleCount;
end;

function BalerInfo:getSpeci(attachedVehicle, specName, currentModName)
	local spec = attachedVehicle["spec_" .. Utils.getNoNil(currentModName, BalerInfo.currentModName) .. "." .. specName];
	if spec ~= nil then
        return spec;
    end;
    return attachedVehicle["spec_" .. specName];
end;