-- Author: DanioMods
-- Date: 09.06.2021
-- Version: Farming Simulator 19, 1.0.0.0
-- Copyright (C): DanioMods, All Rights Reserved
-- Handling cruise control lock HUD

CruiseControlLockUI = {}

modDirectory = g_currentModDirectory

local CruiseControlLockUI_mt = Class(CruiseControlLockUI)

function CruiseControlLockUI:new(mission, i18n, modDirectory, gui)
	local self = setmetatable({}, CruiseControlLockUI_mt)
	
	self.mission = mission
	self.il8n = il8n
	self.modDirectory = modDirectory
	self.gui = gui
	
	self.uiFilename = Utils.getFilename("src/resources/hud/cruiseControlLockHUD_720p.dds", modDirectory)
	
	self.hud = CruiseControlLockHUD:new(mission, mission.hud.speedMeter, i18n, self.uiFilename)
	
	return self
end

function CruiseControlLockUI:onMissionLoaded(mission)
	self.hud:load()
end

function CruiseControlLockUI:onEnterVehicle_ap()
	if self:getIsClient() then
		local vehicle = self.controlledVehicle
		local spec = vehicle.spec_drivable
		
		if spec ~= nil then
			local ui = g_cruiseControlLock.hud
		
			ui:setVehicle(vehicle or nil)
		end
	end
end

function CruiseControlLockUI:onLeaveVehicle_ap()
	if self:getIsClient() then
		local ui = g_cruiseControlLock.hud
		
		ui:setVehicle(nil)
	end
end

function CruiseControlLockUI:delete()
	self.hud:delete()
end