-- Author: DanioMods
-- Date: 09.06.2021
-- Version: Farming Simulator 19, 1.0.0.0
-- Copyright (C): DanioMods, All Rights Reserved
-- HUD for cruise control lock

CruiseControlLockHUD = {}

local CruiseControlLockHUD_mt = Class(CruiseControlLockHUD)

function CruiseControlLockHUD:new(mission, speedMeterDisplay, i18n, uiFilename)
	local instance = setmetatable({}, CruiseControlLockHUD_mt)
	
	instance.speedMeterDisplay = speedMeterDisplay
	instance.il8n = il8n
	instance.uiFilename = uiFilename
	instance.vehicle = nil
	
	SpeedMeterDisplay.draw = Utils.appendedFunction(SpeedMeterDisplay.draw, CruiseControlLockHUD.draw_ap)
	
	return instance
end

function CruiseControlLockHUD:delete()
	if self.main ~= nil then
		self.main:delete()
	end
end

function CruiseControlLockHUD:load()
	self:createComponents()
	self:setVehicle(nil)
end

function CruiseControlLockHUD:createComponents()
	local rightX = 1 - g_safeFrameOffsetX
	local posX, posY = SpeedMeterDisplay.getBackgroundPosition(1)
	local marginWidth, marginHeight = self.speedMeterDisplay:scalePixelToScreenVector(CruiseControlLockHUD.SIZE.BOX_MARGIN)
	local baseBox = self:createBaseBox(self.uiFilename, rightX - marginWidth, posY - marginHeight)
end

function CruiseControlLockHUD:createBaseBox(hudAtlasPath, baseX, baseY)
	local boxWidth, boxHeight = self.speedMeterDisplay:scalePixelToScreenVector(CruiseControlLockHUD.SIZE.BOX)
	local posX = baseX - boxWidth * 0.5
	local iconWidth, iconHeight = self.speedMeterDisplay:scalePixelToScreenVector(CruiseControlLockHUD.SIZE.ICON)
	local baseBoxOverlay = Overlay:new(nil, posX, baseY, boxWidth, boxHeight)
	local baseBoxElement = HUDElement:new(baseBoxOverlay)
	
	self.main = baseBoxElement
	self.main:setVisible(true)
	self.speedMeterDisplay:addChild(self.main)
	
	self.cruiseControlLockIcon = self:createIcon(hudAtlasPath, posX, baseY, iconWidth, iconHeight, CruiseControlLockHUD.UV.CRUISE_CONTROL_UNLOCKED)
	self.main:addChild(self.cruiseControlLockIcon)
	self.cruiseControlLockIcon:setVisible(true)
end

function CruiseControlLockHUD:createIcon(imagePath, baseX, baseY, width, height, uvs)
	local iconOverlay = Overlay:new(imagePath, baseX, baseY, width, height)
	iconOverlay:setUVs(getNormalizedUVs(uvs, CruiseControlLockHUD.TEXTURE_SIZE.CRUISE_CONTROL_LOCK_HUD))
	local iconElement = HUDElement:new(iconOverlay)
	
	iconElement:setVisible(false)
	
	return iconElement
end

function CruiseControlLockHUD:draw()
	if self.speedMeterDisplay.isVehicleDrawSafe and self.vehicle ~= nil and self.main:getVisible() then
		local spec = self.vehicle.spec_drivable
		local uvs = spec.isLocked and CruiseControlLockHUD.UV.CRUISE_CONTROL_LOCKED or CruiseControlLockHUD.UV.CRUISE_CONTROL_UNLOCKED
	
		self.cruiseControlLockIcon:setUVs(getNormalizedUVs(uvs, CruiseControlLockHUD.TEXTURE_SIZE.CRUISE_CONTROL_LOCK_HUD))
	end
end

function CruiseControlLockHUD:draw_ap(speedMeterDisplay)
	g_cruiseControlLock.hud:draw()
end

function CruiseControlLockHUD:setVehicle(vehicle)
	self.vehicle = vehicle
	
	if self.main ~= nil then
		self.main:setVisible(vehicle ~= nil)
	end
end

CruiseControlLockHUD.SIZE = {
	BOX = { 25, 25 },
	BOX_MARGIN = { 135, 262 },
	ICON = { 25, 25 },
}

CruiseControlLockHUD.UV = {
	CRUISE_CONTROL_LOCKED = { 256, 0, 256, 256 },
	CRUISE_CONTROL_UNLOCKED = { 0, 0, 256, 256 },
}

CruiseControlLockHUD.TEXTURE_SIZE = {
	CRUISE_CONTROL_LOCK_HUD = { 512, 256 },
}