-- Author: DanioMods
-- Date: 09.06.2021
-- Version: Farming Simulator 19, 1.0.0.0
-- Copyright (C): DanioMods, All Rights Reserved
-- Handling all functions of cruise control lock

local modDirectory = g_currentModDirectory

source(modDirectory .. "src/specialization/CruiseControlLock.lua")
source(modDirectory .. "src/gui/CruiseControlLockUI.lua")
source(modDirectory .. "src/gui/hud/CruiseControlLockHUD.lua")

local cruiseControlLock

function init()
	Drivable.onLoad = Utils.appendedFunction(Drivable.onLoad, CruiseControlLock.onLoad_af)
	Drivable.onUpdate = Utils.overwrittenFunction(Drivable.onUpdate, CruiseControlLock.onUpdate_ow)
	Drivable.onRegisterActionEvents = Utils.appendedFunction(Drivable.onRegisterActionEvents, CruiseControlLock.onRegisterActionEvents_af)
	Drivable.onLeaveVehicle = Utils.overwrittenFunction(Drivable.onLeaveVehicle, CruiseControlLock.onLeaveVehicle_ow)
	
	Mission00.load = Utils.prependedFunction(Mission00.load, loadMission_pf)
	Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, loadedMission_ap)
	FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, delete_ap)
	
	BaseMission.onEnterVehicle = Utils.appendedFunction(BaseMission.onEnterVehicle, CruiseControlLockUI.onEnterVehicle_ap)
	BaseMission.onLeaveVehicle = Utils.appendedFunction(BaseMission.onLeaveVehicle, CruiseControlLockUI.onLeaveVehicle_ap)
end

function loadMission_pf(mission)
	cruiseControlLock = CruiseControlLockUI:new(mission, g_i18n, modDirectory, g_gui)
	
	getfenv(0).g_cruiseControlLock = cruiseControlLock
	
	addModEventListener(cruiseControlLock)
end

function loadedMission_ap(mission, node)
	if mission.cancelLoading then
		return
	end
	
	cruiseControlLock:onMissionLoaded(mission)
end

function delete_ap()
	removeModEventListener(cruiseControlLock)
	cruiseControlLock:delete()
	cruiseControlLock = nil
	getfenv(0).g_cruiseControlLock = nil
end

init()