-- Author: DanioMods
-- Date: 07.06.2021
-- Version: Farming Simulator 19, 1.0.0.0
-- Copyright (C): DanioMods, All Rights Reserved
-- Cruise control lock specialization

CruiseControlLock = {}

function CruiseControlLock:onLoad_af(savegame)
	local spec = self.spec_drivable
	spec.isLocked = false
	spec.inputChange = 0
end

function CruiseControlLock:onUpdate_ow(superFunc, dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local spec = self.spec_drivable

	if self.isClient and self.getIsEntered ~= nil and self:getIsEntered() then
		if self:getIsActiveForInput(true, true) then
			if self:getIsVehicleControlledByPlayer() then
				spec.doHandbrake = false
				local axisForward = MathUtil.clamp(spec.lastInputValues.axisAccelerate - spec.lastInputValues.axisBrake, -1, 1)
				spec.axisForward = axisForward
				local speedFactor = 1
				local sensitivitySetting = g_gameSettings:getValue(GameSettings.SETTING.STEERING_SENSITIVITY)

				if spec.lastInputValues.axisSteerIsAnalog then
					local isArticulatedSteering = self.spec_articulatedAxis ~= nil and self.spec_articulatedAxis.componentJoint ~= nil
					speedFactor = isArticulatedSteering and 1.5 or 2.5

					if spec.lastInputValues.axisSteerDeviceCategory == InputDevice.CATEGORY.GAMEPAD then
						speedFactor = speedFactor * sensitivitySetting
					end
				elseif spec.lastInputValues.axisSteer == 0 then
					local rotateBackSpeedSetting = g_gameSettings:getValue(GameSettings.SETTING.STEERING_BACK_SPEED) / 10

					if rotateBackSpeedSetting < 1 and self.speedDependentRotateBack then
						local speed = self:getLastSpeed() / 36
						local setting = rotateBackSpeedSetting / 0.5
						speedFactor = speedFactor * math.min(speed * setting, 1)
					end

					speedFactor = speedFactor * (self.autoRotateBackSpeed or 1) / 1.5
				else
					speedFactor = math.min(1 / (self.lastSpeed * spec.speedRotScale + spec.speedRotScaleOffset), 1)
					speedFactor = speedFactor * sensitivitySetting
				end

				local steeringDuration = (self.wheelSteeringDuration or 1) * 1000
				local rotDelta = dt / steeringDuration * speedFactor

				if spec.axisSide < spec.lastInputValues.axisSteer then
					spec.axisSide = math.min(spec.lastInputValues.axisSteer, spec.axisSide + rotDelta)
				elseif spec.lastInputValues.axisSteer < spec.axisSide then
					spec.axisSide = math.max(spec.lastInputValues.axisSteer, spec.axisSide - rotDelta)
				end
			else
				spec.axisForward = 0

				if self.rotatedTime < 0 then
					spec.axisSide = self.rotatedTime / -self.maxRotTime / self:getSteeringDirection()
				else
					spec.axisSide = self.rotatedTime / self.minRotTime / self:getSteeringDirection()
				end
			end
		else
			spec.doHandbrake = true
			spec.axisForward = 0
		end

		spec.lastInputValues.axisAccelerate = 0
		spec.lastInputValues.axisBrake = 0
		spec.lastInputValues.axisSteer = 0

		if spec.axisForward ~= spec.axisForwardSend or spec.axisSide ~= spec.axisSideSend or spec.doHandbrake ~= spec.doHandbrakeSend then
			spec.axisForwardSend = spec.axisForward
			spec.axisSideSend = spec.axisSide
			spec.doHandbrakeSend = spec.doHandbrake

			self:raiseDirtyFlags(spec.dirtyFlag)
		end
	end
	
	if not spec.isLocked then
		if self.isClient and self.getIsEntered ~= nil and self:getIsEntered() then
			local inputValue = spec.lastInputValues.cruiseControlState
			spec.lastInputValues.cruiseControlState = 0
			
			if inputValue == 1 then
				if spec.cruiseControl.topSpeedTime == Drivable.CRUISECONTROL_FULL_TOGGLE_TIME then
					if spec.cruiseControl.state == Drivable.CRUISECONTROL_STATE_OFF then
					self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_ACTIVE)
					else
						self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_OFF)
					end
				end
				
				if spec.cruiseControl.topSpeedTime > 0 then
					spec.cruiseControl.topSpeedTime = spec.cruiseControl.topSpeedTime - dt
					
					if spec.cruiseControl.topSpeedTime < 0 then
						self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_FULL)
					end
				end
			else
				spec.cruiseControl.topSpeedTime = Drivable.CRUISECONTROL_FULL_TOGGLE_TIME
			end
			
			local lastCruiseControlValue = spec.lastInputValues.cruiseControlValue
			spec.lastInputValues.cruiseControlValue = 0
			
			if lastCruiseControlValue ~= 0 then
				spec.cruiseControl.changeCurrentDelay = spec.cruiseControl.changeCurrentDelay - dt * spec.cruiseControl.changeMultiplier
				spec.cruiseControl.changeMultiplier = math.min(spec.cruiseControl.changeMultiplier + dt * 0.003, 10)
				
				if spec.cruiseControl.changeCurrentDelay < 0 then
					spec.cruiseControl.changeCurrentDelay = spec.cruiseControl.changeDelay
					local dir = MathUtil.sign(lastCruiseControlValue)
					local speed = spec.cruiseControl.speed + dir
					
					self:setCruiseControlMaxSpeed(speed)
					
					if spec.cruiseControl.speed ~= spec.cruiseControl.speedSent then
						if g_server ~= nil then
							g_server:broadcastEvent(SetCruiseControlSpeedEvent:new(self, spec.cruiseControl.speed), nil, nil, self)
						else
							g_client:getServerConnection():sendEvent(SetCruiseControlSpeedEvent:new(self, spec.cruiseControl.speed))
						end
						
						spec.cruiseControl.speedSent = spec.cruiseControl.speed
					end
				end
			else
				spec.cruiseControl.changeCurrentDelay = 0
				spec.cruiseControl.changeMultiplier = 1
			end
		end
	else
		if self.isClient then
			local inputValue = spec.lastInputValues.cruiseControlState
			spec.lastInputValues.cruiseControlState = 0
			
			if inputValue == 1 then
				if spec.cruiseControl.topSpeedTime == Drivable.CRUISECONTROL_FULL_TOGGLE_TIME then
					if spec.cruiseControl.state == Drivable.CRUISECONTROL_STATE_OFF then
					self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_ACTIVE)
					else
						self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_OFF)
					end
				end
				
				if spec.cruiseControl.topSpeedTime > 0 then
					spec.cruiseControl.topSpeedTime = spec.cruiseControl.topSpeedTime - dt
					
					if spec.cruiseControl.topSpeedTime < 0 then
						self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_FULL)
					end
				end
			else
				spec.cruiseControl.topSpeedTime = Drivable.CRUISECONTROL_FULL_TOGGLE_TIME
			end
			
			local lastCruiseControlValue = spec.lastInputValues.cruiseControlValue
			spec.lastInputValues.cruiseControlValue = 0
			
			if lastCruiseControlValue ~= 0 then
				spec.cruiseControl.changeCurrentDelay = spec.cruiseControl.changeCurrentDelay - dt * spec.cruiseControl.changeMultiplier
				spec.cruiseControl.changeMultiplier = math.min(spec.cruiseControl.changeMultiplier + dt * 0.003, 10)
				
				if spec.cruiseControl.changeCurrentDelay < 0 then
					spec.cruiseControl.changeCurrentDelay = spec.cruiseControl.changeDelay
					local dir = MathUtil.sign(lastCruiseControlValue)
					local speed = spec.cruiseControl.speed + dir
					
					self:setCruiseControlMaxSpeed(speed)
					
					if spec.cruiseControl.speed ~= spec.cruiseControl.speedSent then
						if g_server ~= nil then
							g_server:broadcastEvent(SetCruiseControlSpeedEvent:new(self, spec.cruiseControl.speed), nil, nil, self)
						else
							g_client:getServerConnection():sendEvent(SetCruiseControlSpeedEvent:new(self, spec.cruiseControl.speed))
						end
						
						spec.cruiseControl.speedSent = spec.cruiseControl.speed
					end
				end
			else
				spec.cruiseControl.changeCurrentDelay = 0
				spec.cruiseControl.changeMultiplier = 1
			end
		end
	end
	
	local isControlled = self.getIsControlled ~= nil and self:getIsControlled()
	
	if not spec.isLocked then
		if self:getIsVehicleControlledByPlayer() and self.isServer and isControlled then
			local speed, _ = self:getSpeedLimit(true)
			
			if spec.cruiseControl.state == Drivable.CRUISECONTROL_STATE_ACTIVE then
				speed = math.min(speed, spec.cruiseControl.speed)
			end
			
			self:getMotor():setSpeedLimit(speed)
			self:updateVehiclePhysics(spec.axisForward, spec.axisSide, spec.doHandbrake, dt)
		end
	else
		local speed, _ = self:getSpeedLimit(true)
		
		if spec.cruiseControl.state == Drivable.CRUISECONTROL_STATE_ACTIVE then
			speed = math.min(speed, spec.cruiseControl.speed)
		end
		
		self:getMotor():setSpeedLimit(speed)
		self:updateVehiclePhysics(spec.axisForward, spec.axisSide, spec.doHandbrake, dt)
	end
	
	if self.isClient and isControlled then
		self:updateSteeringWheel(spec.steeringWheel, dt, 1)
	end
	-- if you want to make help text to be changing only between on or off without on/off, just delete '--' in front of the text below
	--CruiseControlLock.updateLockCruiseControlText(self)
end

function CruiseControlLock:onRegisterActionEvents_af(superFunc, isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		local spec = self.spec_drivable
		local entered = true
		
		if self.getIsEntered ~= nil then
			entered = self:getIsEntered()
		end
		
		local _, actionEventId = nil
		local level = g_isPresentationVersionShowDrivingHelp and GS_PRIO_HIGH or GS_PRIO_LOW
		
		if self:getIsActiveForInput(true, true) and entered then
			if not self:getIsAIActive() then
				_, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_LOCK_CRUISE_CONTROL, self, CruiseControlLock.actionEventLockCruiseControl, false, true, false, true, nil)
				
				g_inputBinding:setActionEventTextPriority(actionEventId, level)
			end
		end
	end
end

function CruiseControlLock:actionEventLockCruiseControl(actionName, inputValue, callbackState, isAnalog)
	local spec = self.spec_drivable
	
	if spec.inputChange == 1 then
		spec.isLocked = false
		spec.inputChange = 0
	elseif spec.inputChange == 0 then
		spec.isLocked = true
		spec.inputChange = 1
	end
	
	CruiseControlLock.updateLockCruiseControlText(self)
end

function CruiseControlLock:updateLockCruiseControlText()
	local spec = self.spec_drivable
	local actionEvent = spec.actionEvents[InputAction.TOGGLE_LOCK_CRUISE_CONTROL]
	
	if actionEvent ~= nil and actionEvent.actionEventId ~= nil then
		local text = nil
		
		if spec.isLocked then
			text = g_i18n:getText("action_unlockCruiseControl")
		else
			text = g_i18n:getText("action_lockCruiseControl")
		end
		
		g_inputBinding:setActionEventText(actionEvent.actionEventId, text)
	end
end

function CruiseControlLock:onLeaveVehicle_ow()
	local spec = self.spec_drivable
	
	if not spec.isLocked then
		self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_OFF)
		
		if self.brake ~= nil then
			self:brake(1)
		end
	end
	
	return nil
end