RotationNodes = {}

function RotationNodes.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations)
end
function RotationNodes:load(savegame)
    self.ProtationNodes = {}
    local i = 0
    while true do
        local key = string.format("vehicle.ProtationNodes.rotationNode(%d)", i)
        if not hasXMLProperty(self.xmlFile, key) then
            break
        end
        local Pnode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#index"))
        local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile, key .. "#rotSpeed"), 1) * 0.001)
        if Pnode ~= nil then
            table.insert(self.ProtationNodes, {Pnode = Pnode, rotSpeed = rotSpeed, rotation = 0})
        end
        i = i + 1
    end
    self.UrotationNodes = {}
    local i = 0
    while true do
        local key = string.format("vehicle.UrotationNodes.rotationNode(%d)", i)
        if not hasXMLProperty(self.xmlFile, key) then
            break
        end
        local Unode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#index"))
        local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile, key .. "#rotSpeed"), 1) * 0.001)
        if Unode ~= nil then
            table.insert(self.UrotationNodes, {Unode = Unode, rotSpeed = rotSpeed, rotation = 0})
        end
        i = i + 1
    end
    self.WrotationNodes = {}
    local i = 0
    while true do
        local key = string.format("vehicle.WrotationNodes.rotationNode(%d)", i)
        if not hasXMLProperty(self.xmlFile, key) then
            break
        end
        local Wnode = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#index"))
        local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile, key .. "#rotSpeed"), 1) * 0.001)
        if Wnode ~= nil then
            table.insert(self.WrotationNodes, {Wnode = Wnode, rotSpeed = rotSpeed, rotation = 0})
        end
        i = i + 1
    end
	self.lightRaysNodes = {};
    i = 0;
    while true do
        local key = string.format("vehicle.lightRays.ray(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end
        local node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#node"));
        local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile, key .. "#rotSpeed"), 1) * 0.001)
        if node and node > 0 then
            table.insert(self.lightRaysNodes, node);
			setVisibility(node, false);
        end
        i = i + 1;
    end;
	g_currentMission.environment:addWeatherChangeListener(self);
	self.changeLightRaysState = RotationNodes.changeLightRaysState;
	self.weatherChanged = RotationNodes.weatherChanged;
	self.setLightsTypesMask = RotationNodes.setLightsTypesMask;
end

function RotationNodes:delete()
	g_currentMission.environment:removeWeatherChangeListener(self);
end

function RotationNodes:mouseEvent(posX, posY, isDown, isUp, button)
end

function RotationNodes:keyEvent(unicode, sym, modifier, isDown)
end

function RotationNodes:update(dt)
end;

function RotationNodes:changeLightRaysState()
	for i=1, #self.lightRaysNodes do
		local node = self.lightRaysNodes[i];
		local parent = getParent(node);
		if g_currentMission.environment.isSunOn then
			setVisibility(node, false);
		elseif getVisibility(parent) then
			setVisibility(node, true);
		end;
	end;
end;

function RotationNodes:weatherChanged()
	self:changeLightRaysState();
end;

function RotationNodes:updateTick(dt)
    if self.isMotorStarted then
        for _, Pnode in pairs(self.ProtationNodes) do
            Pnode.rotation = (Pnode.rotation + dt * Pnode.rotSpeed) % (2 * math.pi)
            setRotation(Pnode.Pnode, 0, 0, Pnode.rotation)  --- (Pnode.Pnode, , Y, Z)     
        end
    end
        if self.pipeIsUnloading then
            for _, Unode in pairs(self.UrotationNodes) do
                Unode.rotation = (Unode.rotation + dt * Unode.rotSpeed) % (2 * math.pi)
                setRotation(Unode.Unode, Unode.rotation, 0, 0)  ---    (Unode.Unode, , Y, Z)      (  Y -- setRotation(Unode.Unode, 0, Unode.rotation, 0)
            end
    end
        if self:getIsActive() and self.isTurnedOn then
            for _, Wnode in pairs(self.WrotationNodes) do
                Wnode.rotation = (Wnode.rotation + dt * Wnode.rotSpeed) % (2 * math.pi)
                setRotation(Wnode.Wnode, Wnode.rotation, 0, 0)  ---    (Wnode.Wnode, , Y, Z)      (  Y -- setRotation(Wnode.Wnode, 0, Wnode.rotation, 0)
            end
      end
end

function RotationNodes:draw()
end

function RotationNodes:setLightsTypesMask(lightsTypesMask, force, noEventSend)
    if lightsTypesMask ~= self.lightsTypesMask or force then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(VehicleSetLightEvent:new(self, lightsTypesMask), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(VehicleSetLightEvent:new(self, lightsTypesMask));
            end;
        end;
        self.lightsTypesMask = lightsTypesMask;
        local activeLightSetup = self.lights.low;
        local inactiveLightSetup = self.lights.high;
        if self:getUseHighProfile() then
            activeLightSetup = self.lights.high;
            inactiveLightSetup = self.lights.low;
        end
        for _, light in pairs(inactiveLightSetup) do
            if light.decoration ~= nil then
                setVisibility(light.decoration, false);
            end
            if light.realLight ~= nil then
                setVisibility(light.realLight, false);
            end
        end
        for _,light in pairs(activeLightSetup) do
            local lightActive = false;
            for _, lightType in pairs(light.lightTypes) do
                if bitAND(lightsTypesMask, 2^lightType) ~= 0 then
                    lightActive = true;
                    break;
                end
            end
            if light.enableDirection ~= nil then
                lightActive = lightActive and light.enableDirection == self.reverserDirection;
            end
            if light.decoration ~= nil then
                setVisibility(light.decoration, lightActive);

            end
            if light.realLight ~= nil then
                if lightActive then
                    for _, excludedLightType in pairs(light.excludedLightTypes) do
                        if bitAND(lightsTypesMask, 2^excludedLightType) ~= 0 then
                            lightActive = false;
                            break;
                        end
                    end
                end
                if lightActive then
                    setVisibility(light.realLight, true)
                else
                    local active = false;
                    if light.brakeLight ~= nil then
                        if light.brakeLight.isActive then
                            active = true;
                        end
                    end
                    setVisibility(light.realLight, active)
                end
            end
            light.isActive = lightActive;
        end;
		self:changeLightRaysState();
        for _,v in pairs(self.attachedImplements) do
            if v.object ~= nil then
                v.object:setLightsTypesMask(lightsTypesMask, true, true);
            end
        end;
        self:onLightsTypesMaskChanged(lightsTypesMask);
    end;
    return true;
end;
