--
-- indooranim
-- Specialization for T150
--
-- @author  	_-OverClocker-_
-- @version 	v1.0
-- @date  		04/03/20

indooranim = {};

function indooranim.prerequisitesPresent(specializations)
    return 
	SpecializationUtil.hasSpecialization(Motorized, specializations) and 
	SpecializationUtil.hasSpecialization(Enterable, specializations) and 
	SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and  
	SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function indooranim.registerEventListeners(vehicleType)	
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", indooranim);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", indooranim)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", indooranim)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", indooranim)
end

function indooranim:onRegisterActionEvents(isSelected, isActiveForInput)
end

function indooranim.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "playCabAnim", indooranim.playCabAnim)
end

function indooranim:onLoad(savegame)
    local blinkerhebelNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.enterable.indooranim.turnLights.TurnLightKey#node"));
    if blinkerhebelNode ~= nil then
        self.blinkerhebel = {};
        self.blinkerhebel.node = blinkerhebelNode;
        local x, y, z = StringUtil.getVectorFromString(getXMLString(self.xmlFile, "vehicle.enterable.indooranim.turnLights.TurnLightKey#minRot"));
        self.blinkerhebel.minRot = {};
        self.blinkerhebel.minRot[1] = MathUtil.degToRad(Utils.getNoNil(x, 0));
        self.blinkerhebel.minRot[2] = MathUtil.degToRad(Utils.getNoNil(y, 0));
        self.blinkerhebel.minRot[3] = MathUtil.degToRad(Utils.getNoNil(z, 0));

        local x, y, z = StringUtil.getVectorFromString(getXMLString(self.xmlFile, "vehicle.enterable.indooranim.turnLights.TurnLightKey#rotLeft"));
        self.blinkerhebel.leftRot = {};
        self.blinkerhebel.leftRot[1] = MathUtil.degToRad(Utils.getNoNil(x, 0));
        self.blinkerhebel.leftRot[2] = MathUtil.degToRad(Utils.getNoNil(y, 0));
        self.blinkerhebel.leftRot[3] = MathUtil.degToRad(Utils.getNoNil(z, 0));

        local x, y, z = StringUtil.getVectorFromString(getXMLString(self.xmlFile, "vehicle.enterable.indooranim.turnLights.TurnLightKey#rotRight"));
        self.blinkerhebel.rightRot = {};
        self.blinkerhebel.rightRot[1] = MathUtil.degToRad(Utils.getNoNil(x, 0));
        self.blinkerhebel.rightRot[2] = MathUtil.degToRad(Utils.getNoNil(y, 0));
        self.blinkerhebel.rightRot[3] = MathUtil.degToRad(Utils.getNoNil(z, 0));

        self.blinkerhebel.rotTime = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.enterable.indooranim.turnLights.TurnLightKey#rotTime"), 1)*1000;
		self.blinkerhebel.lastDir = 1;
    end;
	local baseString = string.format("vehicle.enterable.indooranim.");
    self.klawishaAnims = {};
    if hasXMLProperty(self.xmlFile, "vehicle.enterable.indooranim.lightkeys") then
        self.klawishaAnims.lights = {};
        i=0;
        while true do
            self.klawishaAnims.lights[i] = getXMLString(self.xmlFile,baseString..string.format("lightkeys.lights#animName%d", i));
            if self.klawishaAnims.lights[i] == nil then
                break;
            end;
            i=i+1;
        end;
        self.klawishaAnims.lightsAw = {};
        i=0;
        while true do
            self.klawishaAnims.lightsAw[i] = getXMLString(self.xmlFile,baseString..string.format("lightkeys.blinkerhebel#animName%d", i));
            if self.klawishaAnims.lightsAw[i] == nil then
                break;
            end;
            i=i+1;
        end;
    end;  
	self.Zagiganie = getXMLString(self.xmlFile, "vehicle.enterable.indooranim.enginestart.ignition#animationName");
end;

function indooranim:onUpdate(dt)  
	local ZagiganieEnableTimeStartDelay = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.motorized.animstart#startenabledur"), 1);
	local ZagiganieEnableTime = (self.spec_motorized.motorStartTime - self.spec_motorized.motorStartDuration) + ZagiganieEnableTimeStartDelay;
	local Duration = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.motorized.animstart#duration"), 1);
	local DisableTime = ZagiganieEnableTime + Duration;
    if self.isClient then
		if self.Zagiganie ~= nil and self.playAnimation ~= nil then
		    if (g_currentMission.time <= DisableTime and g_currentMission.time >= ZagiganieEnableTime  and self.spec_motorized.isMotorStarted) then
                self:playAnimation(self.Zagiganie, 1, nil, true);
		    else
                self:playAnimation(self.Zagiganie, -1, nil, true);
		    end;
		end;	
        if self.klawishaAnims.lights ~= nil then
            for i=0, self.spec_lights.numLightTypes do 
                if bitAND(self.spec_lights.lightsTypesMask, 2^i) ~= 0 then
                    self:playCabAnim(self.klawishaAnims.lights[i], 1);
                else
                    self:playCabAnim(self.klawishaAnims.lights[i], -1);
                end;
            end;
        end;
        if self.klawishaAnims.lightsAw ~= nil then
            for i=0, self.spec_lights.numLightTypes do 
                if self.spec_lights.turnLightState == 3 then
                    self:playCabAnim(self.klawishaAnims.lightsAw[i], 1);
                else
                    self:playCabAnim(self.klawishaAnims.lightsAw[i], -1);
                end;
            end;
        end;
    end;		
end;

function indooranim:onUpdateTick(dt)
    if self:getIsActive() then
        if self.spec_lights.turnLightState ~= nil then
			if self.blinkerhebel ~= nil then
				local dir = 0;
				local hasRotChanged = false;
				local destRot = self.blinkerhebel.minRot;
				if self.spec_lights.turnLightState == 1 then
					destRot = self.blinkerhebel.leftRot;
					dir = 1;
				elseif self.spec_lights.turnLightState == 2 then
					destRot = self.blinkerhebel.rightRot;
					dir = -1;
				end
				if self.blinkerhebel.lastDir ~= dir then
					self.blinkerhebel.lastDir = dir;
					self.blinkerhebel.rotatingTime = 0;
				end
				if self.blinkerhebel.rotatingTime ~= nil then
					self.blinkerhebel.rotatingTime = self.blinkerhebel.rotatingTime + dt;
					local t = math.min(1.0, self.blinkerhebel.rotatingTime / self.blinkerhebel.rotTime);
					if t == 1 then
						self.blinkerhebel.rotatingTime = nil;
					end
					local rot = {getRotation(self.blinkerhebel.node)};
					
					local rx1,ry1,rz1,rw1 = mathEulerToQuaternion(unpack(rot));
					local rx2,ry2,rz2,rw2 = mathEulerToQuaternion(unpack(destRot));
					
					local qx,qy,qz,qw = MathUtil.nlerpQuaternionShortestPath(rx1,ry1,rz1,rw1, rx2,ry2,rz2,rw2, t);
					setQuaternion(self.blinkerhebel.node, qx,qy,qz,qw);
				end
			end;
		end;
	end;
end;

function indooranim:playCabAnim(animName, animSpeed)    
    local animTime = self:getAnimationTime(animName);
    if not self:getIsAnimationPlaying(animName) then    
        self:playAnimation(animName, animSpeed, animTime, true);
    end;
end;

function indooranim:actionCallback(actionName, keyStatus, arg4, arg5, arg6)
    if self.isClient then
    end
end