----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

instantWash = {};
instantWash.modDirectory  = g_currentModDirectory;
local modDescFile = loadXMLFile("modDesc", instantWash.modDirectory .. "modDesc.xml");
instantWash.title = getXMLString(modDescFile, "modDesc.title.en");
instantWash.author = getXMLString(modDescFile, "modDesc.author");
instantWash.version = getXMLString(modDescFile, "modDesc.version");
delete(modDescFile);
instantWash.inputKey = Input.KEY_insert;
instantWash.washTime = 0;
--instantWash.buttonDown = false;
instantWash.washSound = createSample("washSound");
loadSample(instantWash.washSound, instantWash.modDirectory.."washSound.ogg", false);

print("Load mod: "..instantWash.title.." : v"..instantWash.version.." by "..instantWash.author);

function instantWash.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Washable, specializations);
end;

--[[function instantWash.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "removeActionEvents", instantWash.removeActionEvents);
    SpecializationUtil.registerFunction(vehicleType, "updateActionEvents", instantWash.updateActionEvents);
    SpecializationUtil.registerFunction(vehicleType, "registerActionEvents", instantWash.registerActionEvents);
end;]]

function instantWash.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", instantWash);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", instantWash);
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", instantWash);
end;

function instantWash:onLoad(savegame)
	if self.spec_washable ~= nil then
		local spec = self.spec_washable;
		spec.washEffect = {};
		spec.washEffect.isActive = false;	
		local psData = {};
		local scaleFactor = 1.0;
		local x,y,z = getWorldTranslation(self.components[1].node);
		psData.psFile = "particleSystems/wfxSplashes.i3d";
		psData.posX = x; --Set's the X position of the main PS relative to the Vehicle. (no adjustment)
		psData.posY = (y + 3.6); --Set's the Y position of the main PS relative to the Vehicle. (Value increased to include height of the water)
		psData.posZ = (z + 1.0);--Set's the Z position of the main PS relative to the Vehicle. (Slight adjustment forward)
		ParticleUtil.loadParticleSystemFromData(psData, spec.washEffect, nil, false, nil, instantWash.modDirectory, self.components[1].node);
		setScale(spec.washEffect.shape, scaleFactor, scaleFactor, scaleFactor);
	end;
	self.instantWashEvents = {};		
	self.instantWashEventIds = {};
	instantWash:setKeys();
end;

function instantWash:onUpdate(dt)
	local controlledAttachment = false;
	if self.spec_attachable ~= nil then
		if self.spec_attachable.attacherVehicle ~= nil then
			--[[if self.spec_attachable.attacherVehicle == g_currentMission.controlledVehicle then
				controlledAttachment = true;
			else]]if self:getRootVehicle() == g_currentMission.controlledVehicle then
				controlledAttachment = true;
			end;
		end;
	end;
	if self.spec_washable ~= nil then
		if (self == g_currentMission.controlledVehicle or controlledAttachment) then
			if Input.isKeyPressed(instantWash.inputKey) --[[and not instantWash.buttonDown]] then
				for _, nodeData in ipairs(self.spec_washable.washableNodes) do
					self:setNodeDirtAmount(nodeData, 0, true);
					ParticleUtil.setEmittingState(self.spec_washable.washEffect, true);
					self.spec_washable.washEffect.isActive = true;
				end;
				if instantWash.washTime <=0 then
					if not isSamplePlaying(instantWash.washSound) then playSample(instantWash.washSound,1,1,0,0,0); end;
				end;
				if instantWash.washTime < 10 then instantWash.washTime = instantWash.washTime+2; end;
			elseif instantWash.washTime > 0 then
				instantWash.washTime = instantWash.washTime-1;
			end;
			if self.spec_washable.washEffect ~= nil then
				if self.spec_washable.washEffect.isActive then
					if instantWash.washTime <= 0 then
						instantWash.washTime = 0;
						ParticleUtil.setEmittingState(self.spec_washable.washEffect, false);
						self.spec_washable.washEffect.isActive = false;
					end;
				--	instantWash.buttonDown = true;
				--elseif not Input.isKeyPressed(instantWash.inputKey) then
				--	instantWash.buttonDown = false;
				end;
			end;
		else
			if self.spec_washable.washEffect ~= nil then
				if self.spec_washable.washEffect.isActive then
					ParticleUtil.setEmittingState(self.spec_washable.washEffect, false);
					self.spec_washable.washEffect.isActive = false;
				end;
			end;
		end;
	end;
	
	if g_gui:getIsGuiVisible() and instantWash.controlsChanged == nil then -- Reload Key Configuration 
		instantWash.controlsChanged = true;
	elseif instantWash.controlsChanged ~= nil and not g_gui:getIsGuiVisible() then		
		instantWash:setKeys();
		instantWash.controlsChanged = nil;
	end;	
end;

function instantWash:toggleActive()
--------------
end;

function instantWash:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		self:clearActionEventsTable(self.instantWashEvents);
		self.instantWashEventIds = {};		
        if self:getIsActiveForInput(true, true) then
			local _, actionEventId = self:addActionEvent(self.instantWashEvents, 'instantWash_washKey', self, instantWash.toggleActive, false, true, false, true, nil);
			g_inputBinding:setActionEventTextVisibility(actionEventId, false);
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_LOW);
			table.insert(self.instantWashEventIds, actionEventId);
			if actionEventId == "" then
				_, actionEventId = self:addActionEvent(self.instantWashEvents, 'instantWash_washKey', self, instantWash.toggleActive, false, true, false, true, nil);
				g_inputBinding:setActionEventTextVisibility(actionEventId, false);
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_LOW);
				table.insert(self.instantWashEventIds, actionEventId);
			end;
		end;
	end;
end;

function instantWash:setKeys()
	local xmlFile = loadXMLFile("inputBinding", getUserProfileAppPath().."inputBinding.xml");	
	local i = 0;
	while true do
		local objKey = string.format("inputBinding.actionBinding(%d)", i);
		local inputKey = getXMLString(xmlFile, objKey.."#action")
		if inputKey == nil then break; end;
		if string.lower(inputKey) == "instantwash_washkey" then
			instantWash.inputKey = Input[getXMLString(xmlFile, objKey.. ".binding#input")];
			break;
		end;
        i = i + 1;
    end;
end;