----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

source(Utils.getFilename("instantWash.lua", g_currentModDirectory));

instantWashRegister = {};

function installSpec()
	if g_specializationManager:getSpecializationByName("instantWash") == nil then
		if instantWash == nil then 
			print("ERROR: unable to find source file 'instantWash'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.vehicleTypes) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isWashable = false;
					for name, spec in pairs(typeDef.specializationsByName) do
						if name == "washable" then 
							isWashable = true;
						end;
					end;
					if isWashable then
						typeDef.specializationsByName["instantWash"] = instantWash;
						table.insert(typeDef.specializationNames, "instantWash");
						table.insert(typeDef.specializations, instantWash);
					end;
				end;
			end;
		end;	
	end;
end;

VehicleTypeManager.validateVehicleTypes = Utils.prependedFunction(VehicleTypeManager.validateVehicleTypes, installSpec);