--
-- FS19 - Timber Trailer Info
-- @author:    	kenny456 (kenny456@seznam.cz)
-- @history:	v1.0.0.0 - 2021-03-10 - first release
--
source(Utils.getFilename("timberTrailerInfo.lua", g_currentModDirectory))

TimberTrailerInfo_register = {}

function TimberTrailerInfo_register:loadMap()
end
function TimberTrailerInfo_register:register(name)
	if g_specializationManager:getSpecializationByName("TimberTrailerInfo") == nil then
		if TimberTrailerInfo == nil then 
			print("ERROR: unable to add specialization 'TimberTrailerInfo'")
		else 
			for i, typeDef in pairs(g_vehicleTypeManager.vehicleTypes) do
				if typeDef ~= nil and i ~= "locomotive" then 
					local isDynamicMountAttacher  = false
					local isTrailer  = false
					local isTransportTrailer  = false
					local isForwarder  = false
					local isForwarderTrailer  = false
					local isWoodTruck  = false
					local isTensionBelts  = false
					for name, spec in pairs(typeDef.specializationsByName) do
						if name == "dynamicMountAttacher"  then 
							isDynamicMountAttacher = true 
						elseif name == "trailer"  then 
							isTrailer = true 
						elseif name == "tensionBelts"  then 
							isTensionBelts = true 
						end 
					end
					if i == "transportTrailer" then
						isTransportTrailer = true
					end
					if i == "forwarder" then
						isForwarder = true
					end
					if i == "forwarderTrailer" then
						isForwarderTrailer = true
					end
					if i == "woodTruck" then
						isWoodTruck = true
					end
					if isDynamicMountAttacher or isTrailer or isTransportTrailer or isForwarder or isForwarderTrailer or isWoodTruck or isTensionBelts then
					  typeDef.specializationsByName["TimberTrailerInfo"] = TimberTrailerInfo
					  table.insert(typeDef.specializationNames, "TimberTrailerInfo")
					  table.insert(typeDef.specializations, TimberTrailerInfo)  
					end 
				end 
			end   
		end 
	end
end
VehicleTypeManager.finalizeVehicleTypes = Utils.prependedFunction(VehicleTypeManager.finalizeVehicleTypes, TimberTrailerInfo_register.register)
print("----TimberTrailerInfo registered.")

addModEventListener(TimberTrailerInfo_register)