--
-- FS19 - Timber Trailer Info
-- @author:    	kenny456 (kenny456@seznam.cz)
-- @history:	v1.0.0.0 - 2021-03-10 - first release
--
TimberTrailerInfo = {}
TimberTrailerInfo.confDir = getUserProfileAppPath().. "modsSettings/TimberTrailerInfo/"
TimberTrailerInfo.modDirectory = g_currentModDirectory
TimberTrailerInfo.vehicles = {}
TimberTrailerInfo.showHelp = true

function TimberTrailerInfo.prerequisitesPresent(specializations)
	return true
end
function TimberTrailerInfo.registerOverwrittenFunctions(vehicleType)
end
function TimberTrailerInfo.registerFunctions(vehicleType)
end
function TimberTrailerInfo:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
	
	if spec.event_IDs == nil then
		spec.event_IDs = {}
	else
		self:clearActionEventsTable(spec.event_IDs)
	end
	if self:getIsActiveForInput() or (self.getIscontrolled ~= nil and self:getIsControlled()) then
		if g_dedicatedServerInfo ~= nil then
			return
		end
		local actions = { InputAction.TIMBER_TRAILER_INFO_TOGGLE_ACTIVE }
		for _,actionName in pairs(actions) do
			local always = (actionName == InputAction.WORKRPM_MOVE_HUD_TRIGGER) and true or false
			local _, eventID = g_inputBinding:registerActionEvent(actionName, self, TimberTrailerInfo.actionCallback, true, true, always, true)
			spec.event_IDs[actionName] = eventID
			if g_inputBinding ~= nil and g_inputBinding.events ~= nil and g_inputBinding.events[eventID] ~= nil then
				if actionName == 'something with lower priority' then
					g_inputBinding:setActionEventTextPriority(eventID, GS_PRIO_NORMAL)
				else
					g_inputBinding:setActionEventTextPriority(eventID, GS_PRIO_VERY_HIGH)-----------------------------	ZKUSIT NIZSI PRIORITU
				end
				g_inputBinding:setActionEventTextVisibility(eventID, TimberTrailerInfo.showHelp)
			end
			local colliding = false
			_, colliding, _ = g_inputBinding:checkEventCollision(actionName)
			if colliding then
				if g_inputBinding.nameActions[actionName].bindings[1] ~= nil then
					if g_inputBinding.nameActions[actionName].bindings[1].inputString ~= nil then
						print(string.format('Warning: TimberTrailerInfo got a colliding input action: %s', actionName)..' ('..g_inputBinding.nameActions[actionName].bindings[1].inputString..'). You can remap it in controls settings')
					end
				else
					print(string.format('Warning: TimberTrailerInfo got a colliding input action: %s', actionName))
				end
			end
		end
	end
end
function TimberTrailerInfo.registerEventListeners(vehicleType)
	for _,n in pairs( { "onLoad", "onPostLoad", "onDelete", "saveToXMLFile", "onUpdate", "onUpdateTick", "onDraw", "onReadStream", "onWriteStream", "onRegisterActionEvents" } ) do
		SpecializationUtil.registerEventListener(vehicleType, n, TimberTrailerInfo)
	end
end
function TimberTrailerInfo:onLoad(savegame)
	self.spec_timberTrailerInfo = {}
	local spec = self.spec_timberTrailerInfo
end
function TimberTrailerInfo:onPostLoad(savegame)
	local spec = self.spec_timberTrailerInfo

	spec.modInitialized = false
	spec.modAllowed = true
	if self:getFullName() == 'Fortschritt HW 80 Wood Trailer' then
		spec.dynamicMountTrigger = I3DUtil.indexToObject(self.components, '0>4')
	else
		spec.dynamicMountTrigger = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.dynamicMountAttacher#triggerNode"), self.i3dMappings)
	end
	if spec.dynamicMountTrigger == nil then
		spec.dynamicMountTrigger = I3DUtil.indexToObject(self.components, self.i3dMappings.dynamicMountTrigger)
	end
	if spec.dynamicMountTrigger ~= nil then
		if (self.spec_dynamicMountAttacher ~= nil and self.spec_dynamicMountAttacher.dynamicMountAttacherTrigger ~= nil) or (self.spec_vehicleStraps ~= nil and self.spec_vehicleStraps.dynamicMountTrigger ~= nil) or self.dynamicMountTriggerActivated then
			spec.modInitialized = true
		else
			local attacherTriggerTriggerNode = spec.dynamicMountTrigger
			local attacherTriggerRootNode = I3DUtil.indexToObject(self.components, Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.dynamicMountAttacher#rootNode"), '0>'), self.i3dMappings)
			local attacherTriggerJointNode = I3DUtil.indexToObject(self.components, Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.dynamicMountAttacher#jointNode"), '0>'), self.i3dMappings)
			if attacherTriggerTriggerNode ~= nil and getRigidBodyType(attacherTriggerTriggerNode) ~= 'NoRigidBody' then
				local forceAcceleration = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.dynamicMountAttacher#forceAcceleration"), 30)
				addTrigger(attacherTriggerTriggerNode, "dynamicMountTriggerCallback", self)
				local mountTypeString = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.dynamicMountAttacher#mountType"), "TYPE_AUTO_ATTACH_XZ")
				local mountType = Utils.getNoNil(DynamicMountUtil[mountTypeString], DynamicMountUtil.TYPE_AUTO_ATTACH_XZ)
				spec.modInitialized = true
				self.dynamicMountTriggerActivated = true
			end
		end
	end
	if not spec.modInitialized then
		--print("Error: TimberTrailerInfo initialization failed for "..tostring(self:getFullName()).." ! "..tostring(SpecializationUtil.hasSpecialization(DynamicMountAttacher, self.specializations)))
		return
	else
	end
	
	if self.dynamicMountTriggerCallback == nil then
		self.dynamicMountTriggerCallback = TimberTrailerInfo.dynamicMountTriggerCallback
	else
		self.dynamicMountTriggerCallback = Utils.appendedFunction(self.dynamicMountTriggerCallback, TimberTrailerInfo.dynamicMountTriggerCallback)
	end
	
	spec.modActive = true
	spec.woodLoad = {}
	if self.spec_autoLoadWood ~= nil then
		spec.modActive = false
	end
	if savegame ~= nil then
		local xmlFile = savegame.xmlFile
		local key = savegame.key ..".TimberTrailerInfo"
		spec.modActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#modActive"), spec.modActive)
	end
end
function TimberTrailerInfo:onDelete()
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
	
	if spec.dynamicMountTrigger ~= nil then
        removeTrigger(spec.dynamicMountTrigger)
    end
end
function TimberTrailerInfo:saveToXMLFile(xmlFile, key)
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
	
	setXMLBool(xmlFile, key.."#modActive", spec.modActive)
end
function TimberTrailerInfo:onUpdate(dt)
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
	
	local count = 0
	local mass = 0
	local volume = 0
	if spec.modActive then
		if self:getIsActive() then
			for k, shape in pairs(spec.woodLoad) do
				if entityExists(shape) then
					count = count + 1
					mass = mass + getMass(shape)
					volume = volume + getVolume(shape)
				else
					spec.woodLoad[k] = nil
				end
			end
		end
	end

	if self.isClient then
		if self:getIsActiveForInput() or (self.getIscontrolled ~= nil and self:getIsControlled()) then
			if spec.event_IDs ~= nil and g_dedicatedServerInfo == nil then
				for actionName,eventID in pairs(spec.event_IDs) do
					if actionName == InputAction.TIMBER_TRAILER_INFO_TOGGLE_ACTIVE then
						g_inputBinding:setActionEventActive(eventID, true)
						g_inputBinding:setActionEventText(eventID, spec.modActive and g_i18n:getText('TIMBER_TRAILER_INFO_DEACTIVATE') or g_i18n:getText('TIMBER_TRAILER_INFO_ACTIVATE'))
					end
				end
			end
			if spec.modActive then
				if count > 0 then
					g_currentMission:addExtraPrintText(g_i18n:getText('TIMBER_TRAILER_INFO_COUNT').." "..count.." ("..string.format('%.1f', mass).." t / "..string.format('%.1f', volume).." m3)")
				else
					g_currentMission:addExtraPrintText(g_i18n:getText('TIMBER_TRAILER_INFO_NO_LOGS'))
				end
			end
		end
	end
end
function TimberTrailerInfo:dynamicMountTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	local spec = self.spec_timberTrailerInfo
	
	local debug = false
	local splitType = g_splitTypeManager:getSplitTypeByIndex(getSplitType(otherActorId))
	if splitType ~= nil then
		if onEnter then
			if debug then print('TimberTrailer enter otherActorId '..otherActorId) end
			if spec.woodLoad[otherActorId] == nil then
				spec.woodLoad[otherActorId] = otherActorId
			end
		elseif onLeave then
			if spec.woodLoad[otherActorId] ~= nil then
				spec.woodLoad[otherActorId] = nil
			end
		end
	end
end
function TimberTrailerInfo:onUpdateTick(dt)
end
function TimberTrailerInfo:actionCallback(actionName, keyStatus, arg4, arg5, arg6)
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
	
	if self:getIsActive() then
		if keyStatus > 0 then
			if actionName == 'TIMBER_TRAILER_INFO_TOGGLE_ACTIVE' then
				spec.modActive  = not spec.modActive 
			end
		end
	end
end
function TimberTrailerInfo:onDraw()
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
end
function TimberTrailerInfo:onReadStream(streamId, connection)
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
end
function TimberTrailerInfo:onWriteStream(streamId, connection)
	local spec = self.spec_timberTrailerInfo
	if not spec.modInitialized or not spec.modAllowed then
		return
	end
end