DarkExhaustSmoke = {}

function DarkExhaustSmoke.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations)
end
function DarkExhaustSmoke.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "onExhaustEffectI3DLoaded", DarkExhaustSmoke.onExhaustEffectI3DLoaded)
end

function DarkExhaustSmoke:onExhaustEffectI3DLoaded(superFunc, i3dNode, failedReason, args)
	local spec = self.spec_motorized
	superFunc(self, i3dNode, failedReason, args)
	local hasDEF = self:getFirstValidFillUnitToFill(FillType.DEF, true) ~= nil
	if spec.exhaustEffects ~= nil then
		for _, effect in pairs(spec.exhaustEffects) do
			effect.minRpmColor = {0.01, 0.01, 0.015, hasDEF and effect.minRpmColor[4] or effect.minRpmColor[4]*10}
			effect.maxRpmColor = {0.01, 0.01, 0.015, hasDEF and effect.maxRpmColor[4] or effect.maxRpmColor[4]*10}
		end
	end
end
