--
-- Full Stop
--
-- # Author:  Naduweisstschon
-- # date: 06.04.2019
--

FullStop = {}

function FullStop.prerequisitesPresent(specializations)
  return SpecializationUtil.hasSpecialization(Pipe, specializations)
    and SpecializationUtil.hasSpecialization(Combine, specializations)
    and SpecializationUtil.hasSpecialization(FillUnit, specializations)
    and SpecializationUtil.hasSpecialization(Dischargeable, specializations)
end

function FullStop.registerEventListeners(vehicleType)
  SpecializationUtil.registerEventListener(vehicleType, "onUpdate", FullStop)
end

function FullStop:onUpdate(dt)
  -- Only execute server-side
  if self.isServer then

    local spec = self.spec_fullStop
    local fillLevel = self:getFillUnitFillLevelPercentage(self:getCurrentDischargeNode().fillUnitIndex)

    -- Combine is stopped
    if spec.stopped then
      
      if fillLevel < 1 then
        spec.stopped = false
      end

      if self:getLastSpeed() <= 0.1 then
        -- Hold the brakes for a little longer, in case the driver
        -- is holding the gas pedal and hasn't noticed, that the
        -- combine is full.
        spec.stopTime = spec.stopTime + dt
      end

      if spec.stopTime < 2000 then
        self:setBrakeLightsVisibility(true)
      
        -- The general brake force of the vehicle or something like that
        local brakeForce = self:getBrakeForce()

        -- Iterate over all the wheels of the vehicle
        for k, wheel in pairs(self:getWheels()) do
          -- Apply some magic forces
          setWheelShapeProps(wheel.node, wheel.wheelShape, 0, brakeForce * wheel.brakeFactor, wheel.steeringAngle, wheel.rotationDamping)
          setWheelShapeAutoHoldBrakeForce(wheel.node, wheel.wheelShape, brakeForce * wheel.autoHoldBrakeFactor)
        end

        -- Brake for good measure!??
        self:brake(brakeForce)
      end

      return
    end

    -- My mental health suffers from modding FS19
    if not spec.stopped and fillLevel == 1 then
      self:setCruiseControlState(Drivable.CRUISECONTROL_STATE_OFF)
      self:setPipeState(2)
      spec.stopped = true
      spec.stopTime = 0
    end

  end
end
