-- sounds/turboBlowOff.lua
BlowOffSound = {}

function BlowOffSound.prerequisitesPresent(specializations)
    return true
end

function BlowOffSound.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", BlowOffSound)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", BlowOffSound)
end

function BlowOffSound:onLoad(savegame)
    self.blowOffSoundId = createSample("blowoffSound")
    local soundFile = Utils.getFilename("sounds/blowoff.wav", self.baseDirectory)
    loadSample(self.blowOffSoundId, soundFile, false)
    self.previousSpeed = 0
    self.previousRPM = 0
end

function BlowOffSound:onUpdate(dt)
    local currentSpeed = self:getLastSpeed()
    local currentRPM = self.spec_motorized.motor:getLastMotorRpm()

    if (self.previousSpeed ~= nil and currentSpeed < self.previousSpeed - 1) or 
       (self.previousRPM ~= nil and currentRPM < self.previousRPM - 100) then
        playSample(self.blowOffSoundId, 1, 1, 0, 0, 0)
    end

    self.previousSpeed = currentSpeed
    self.previousRPM = currentRPM
end